/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.SourceSetHelper;
import org.unbrokendome.gradle.plugins.testsets.internal.events.DirNameChangedEvent;
import org.unbrokendome.gradle.plugins.testsets.internal.events.TestSetAddedEvent;

public class SourceSetListener {
    private final Project project;

    public SourceSetListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void testSetAdded(TestSetAddedEvent event) {
        TestSet testSet = event.getTestSet();
        this.createSourceSet(testSet);
        this.createDependency(testSet);
    }

    private void createSourceSet(TestSet testSet) {
        SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(this.project);
        sourceSets.create(testSet.getSourceSetName());
    }

    private void createDependency(TestSet testSet) {
        SourceSet mainSourceSet = this.getMainSourceSet();
        this.project.getDependencies().add(testSet.getCompileConfigurationName(), (Object)mainSourceSet.getOutput());
    }

    private SourceSet getMainSourceSet() {
        SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(this.project);
        return (SourceSet)sourceSets.getByName("main");
    }

    @Subscribe
    public void dirNameChanged(DirNameChangedEvent event) {
        TestSet testSet = event.getTestSet();
        String dirName = event.getDirName();
        SourceSet sourceSet = SourceSetHelper.getSourceSet(this.project, testSet.getSourceSetName());
        this.applyJavaSrcDir(sourceSet, dirName);
        this.applyResourcesSrcDir(sourceSet, dirName);
        this.applyGroovySrcDir(sourceSet, dirName);
    }

    private void applyResourcesSrcDir(SourceSet sourceSet, String dirName) {
        String resourcesSrcDir = String.format("src/%s/resources", dirName);
        sourceSet.getResources().setSrcDirs(Collections.singleton(resourcesSrcDir));
    }

    private void applyJavaSrcDir(SourceSet sourceSet, String dirName) {
        String javaSrcDir = String.format("src/%s/java", dirName);
        sourceSet.getJava().setSrcDirs(Collections.singleton(javaSrcDir));
    }

    private void applyGroovySrcDir(SourceSet sourceSet, String dirName) {
        GroovySourceSet groovySourceSet = (GroovySourceSet)new DslObject((Object)sourceSet).getConvention().findPlugin(GroovySourceSet.class);
        if (groovySourceSet != null) {
            String groovySrcDir = String.format("src/%s/groovy", dirName);
            groovySourceSet.getGroovy().setSrcDirs(Collections.singleton(groovySrcDir));
        }
    }
}

