/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.AbstractConventionPropertySource;
import org.unbrokendome.gradle.plugins.testsets.internal.SourceSetHelper;
import org.unbrokendome.gradle.plugins.testsets.internal.conventions.ConventionHelper;
import org.unbrokendome.gradle.plugins.testsets.internal.conventions.ConventionProperty;
import org.unbrokendome.gradle.plugins.testsets.internal.events.TestSetAddedEvent;

public class JarTaskListener {
    private final Project project;

    public JarTaskListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void testSetAdded(TestSetAddedEvent event) {
        final TestSet testSet = event.getTestSet();
        Jar jarTask = (Jar)this.project.getTasks().create(testSet.getJarTaskName(), Jar.class);
        ConventionHelper.applyConventionProperties((IConventionAware)jarTask, new JarTaskConventionPropertySource(this.project, testSet));
        jarTask.from(new Object[]{new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SourceSet sourceSet = SourceSetHelper.getSourceSet(JarTaskListener.this.project, testSet.getSourceSetName());
                return sourceSet.getOutput();
            }
        }});
    }

    private static class JarTaskConventionPropertySource
    extends AbstractConventionPropertySource {
        public JarTaskConventionPropertySource(Project project, TestSet testSet) {
            super(project, testSet);
        }

        @ConventionProperty(value="description")
        public String getDescription() {
            return "Assembles a jar archive containing the " + this.getTestSet().getName() + " classes.";
        }

        @ConventionProperty(value="group")
        public String getGroup() {
            return "build";
        }

        @ConventionProperty(value="classifier")
        public String getClassifier() {
            return this.getTestSet().getClassifier();
        }
    }
}

