/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.unbrokendome.gradle.plugins.testsets.dsl.ConfigurableTestSet;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.AbstractTestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.events.DirNameChangedEvent;
import org.unbrokendome.gradle.plugins.testsets.internal.events.ExtendsFromAddedEvent;

public class DefaultTestSet
extends AbstractTestSet
implements ConfigurableTestSet {
    private final EventBus eventBus;
    private final String name;
    private final Set<TestSet> extendsFrom = new HashSet<TestSet>();
    private boolean createArtifact = true;
    private String classifier;
    private String dirName;

    public DefaultTestSet(String name, EventBus eventBus) {
        this.name = name;
        this.eventBus = eventBus;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCreateArtifact() {
        return this.createArtifact;
    }

    @Override
    public String getDirName() {
        return this.dirName != null ? this.dirName : this.name;
    }

    @Override
    public void setDirName(String dirName) {
        this.dirName = dirName;
        this.eventBus.post((Object)new DirNameChangedEvent(this, dirName));
    }

    @Override
    public void setCreateArtifact(boolean createArtifact) {
        this.createArtifact = createArtifact;
    }

    @Override
    public ConfigurableTestSet extendsFrom(TestSet ... superTestSets) {
        return this.extendsFromInternal(Arrays.asList(superTestSets));
    }

    private ConfigurableTestSet extendsFromInternal(Collection<TestSet> superTestSets) {
        for (TestSet superTestSet : superTestSets) {
            this.extendsFrom.add(superTestSet);
            this.eventBus.post((Object)new ExtendsFromAddedEvent(this, superTestSet));
        }
        return this;
    }

    @Override
    public Set<TestSet> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public String getClassifier() {
        return this.classifier != null ? this.classifier : this.getName();
    }

    @Override
    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

