/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets.internal;

import com.google.common.eventbus.Subscribe;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.unbrokendome.gradle.plugins.testsets.dsl.TestSet;
import org.unbrokendome.gradle.plugins.testsets.internal.events.ExtendsFromAddedEvent;

public class ConfigurationDependencyListener {
    private final Project project;

    public ConfigurationDependencyListener(Project project) {
        this.project = project;
    }

    @Subscribe
    public void extendsFromAdded(ExtendsFromAddedEvent event) {
        TestSet testSet = event.getTestSet();
        TestSet superTestSet = event.getSuperTestSet();
        this.addConfigurationExtension(testSet.getCompileConfigurationName(), superTestSet.getCompileConfigurationName());
        this.addConfigurationExtension(testSet.getRuntimeConfigurationName(), superTestSet.getRuntimeConfigurationName());
    }

    private void addConfigurationExtension(String configurationName, String superConfigurationName) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        Configuration testSetCompileConfiguration = (Configuration)configurations.findByName(configurationName);
        Configuration mainCompileConfiguration = (Configuration)configurations.findByName(superConfigurationName);
        testSetCompileConfiguration.extendsFrom(new Configuration[]{mainCompileConfiguration});
    }
}

