/*
 * Decompiled with CFR 0.152.
 */
package org.unbrokendome.gradle.plugins.testsets;

import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.internal.reflect.Instantiator;
import org.unbrokendome.gradle.plugins.testsets.internal.ArtifactListener;
import org.unbrokendome.gradle.plugins.testsets.internal.ConfigurationDependencyListener;
import org.unbrokendome.gradle.plugins.testsets.internal.DefaultTestSetContainer;
import org.unbrokendome.gradle.plugins.testsets.internal.EclipseClasspathListener;
import org.unbrokendome.gradle.plugins.testsets.internal.JarTaskListener;
import org.unbrokendome.gradle.plugins.testsets.internal.SourceSetListener;
import org.unbrokendome.gradle.plugins.testsets.internal.TestTaskListener;

public class TestSetsPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final EventBus eventBus = new EventBus("testSetEvents");

    @Inject
    public TestSetsPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        this.eventBus.register((Object)new SourceSetListener(project));
        this.eventBus.register((Object)new ConfigurationDependencyListener(project));
        this.eventBus.register((Object)new TestTaskListener(project));
        this.eventBus.register((Object)new JarTaskListener(project));
        this.eventBus.register((Object)new ArtifactListener(project));
        this.eventBus.register((Object)new EclipseClasspathListener(project));
        project.getExtensions().create("testSets", DefaultTestSetContainer.class, new Object[]{this.instantiator, this.eventBus});
    }
}

