/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.search;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.impl.SearchResponseImpl;
import org.uberfire.ext.security.management.search.RuntimeSearchEngine;

public abstract class AbstractRuntimeSearchEngine<T>
implements RuntimeSearchEngine<T> {
    @Override
    public AbstractEntityManager.SearchResponse<T> search(Collection<T> entities, AbstractEntityManager.SearchRequest request) {
        LinkedList result;
        if (entities == null || request == null) {
            return null;
        }
        if (request.getPage() <= 0) {
            throw new RuntimeException("First page must be 1.");
        }
        String pattern = request.getSearchPattern();
        boolean isPatternEmpty = this.isEmpty(pattern);
        LinkedList linkedList = result = isPatternEmpty ? entities : new LinkedList();
        if (!isPatternEmpty) {
            for (Object entity : entities) {
                String id = this.getIdentifier(entity);
                if (this.isConstrained(request, id) || !id.contains(pattern)) continue;
                result.add(entity);
            }
        }
        return this.createResponse(result, request);
    }

    protected boolean isConstrained(AbstractEntityManager.SearchRequest request, String name) {
        Set constrainedIdentifiers = request.getConstrainedIdentifiers();
        if (null != constrainedIdentifiers) {
            for (String id : constrainedIdentifiers) {
                if (!id.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractEntityManager.SearchResponse<T> createResponse(Collection<T> entities, AbstractEntityManager.SearchRequest request) {
        int endPos;
        int pageSize;
        List<Object> result = new LinkedList<T>(entities);
        int total = result.size();
        int page = request.getPage() - 1;
        int startPos = page * (pageSize = request.getPageSize());
        int n = endPos = startPos + pageSize > total ? total : startPos + pageSize;
        if (result.size() >= startPos) {
            result = result.subList(startPos, endPos);
        }
        return new SearchResponseImpl(result, page + 1, pageSize, total, total > endPos);
    }

    protected abstract String getIdentifier(T var1);

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

