/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;

public class SecurityManagementUtils {
    public static final Capability[] USERS_CAPABILITIES = new Capability[]{Capability.CAN_SEARCH_USERS, Capability.CAN_ADD_USER, Capability.CAN_UPDATE_USER, Capability.CAN_READ_USER, Capability.CAN_DELETE_USER, Capability.CAN_MANAGE_ATTRIBUTES, Capability.CAN_ASSIGN_GROUPS, Capability.CAN_ASSIGN_ROLES, Capability.CAN_CHANGE_PASSWORD};
    public static final Capability[] GROUPS_CAPABILITIES = new Capability[]{Capability.CAN_SEARCH_GROUPS, Capability.CAN_ADD_GROUP, Capability.CAN_UPDATE_GROUP, Capability.CAN_READ_GROUP, Capability.CAN_DELETE_GROUP};
    public static final Capability[] ROLES_CAPABILITIES = new Capability[]{Capability.CAN_SEARCH_ROLES, Capability.CAN_ADD_ROLE, Capability.CAN_UPDATE_ROLE, Capability.CAN_READ_ROLE, Capability.CAN_DELETE_ROLE};

    public static User createUser(String id) {
        return SecurityManagementUtils.createUser(id, null);
    }

    public static User createUser(String id, Set<Group> groups) {
        return SecurityManagementUtils.createUser(id, groups, null);
    }

    public static User createUser(String id, Set<Group> groups, Set<Role> roles) {
        return SecurityManagementUtils.createUser(id, groups, roles, null);
    }

    public static User createUser(String id, Set<Group> groups, Set<Role> roles, Map<String, String> properties) {
        if (id == null) {
            return null;
        }
        HashSet<Group> _groups = groups != null ? new HashSet<Group>(groups) : new HashSet(0);
        HashSet<Role> _roles = roles != null ? new HashSet<Role>(roles) : new HashSet(0);
        HashMap<String, String> _properties = properties != null ? new HashMap<String, String>(properties) : new HashMap(0);
        return new UserImpl(id, _roles, _groups, _properties);
    }

    public static Group createGroup(String name) {
        if (name == null) {
            return null;
        }
        return new GroupImpl(name);
    }

    public static Role createRole(String name) {
        if (name == null) {
            return null;
        }
        return new RoleImpl(name);
    }

    public static User clone(User user) {
        if (user == null) {
            return null;
        }
        String id = user.getIdentifier();
        HashSet groups = user.getGroups() != null ? new HashSet(user.getGroups()) : new HashSet(0);
        HashSet roles = user.getRoles() != null ? new HashSet(user.getRoles()) : new HashSet(0);
        HashMap properties = user.getProperties() != null ? new HashMap(user.getProperties()) : new HashMap(0);
        return new UserImpl(id, roles, groups, properties);
    }

    public static Set<Group> getGroups(UserSystemManager userSystemManager, String username) {
        User user = (User)userSystemManager.users().get(username);
        if (null != user && null != user.getGroups() && !user.getGroups().isEmpty()) {
            return user.getGroups();
        }
        return new HashSet<Group>();
    }

    public static Set<Role> getRoles(UserSystemManager userSystemManager, String username) {
        try {
            User user = (User)userSystemManager.users().get(username);
            if (null != user && null != user.getRoles() && !user.getRoles().isEmpty()) {
                return new HashSet<Role>(user.getRoles());
            }
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        return new HashSet<Role>();
    }

    public static Set<Role> getRegisteredRoles() {
        Set registered = RoleRegistry.get().getRegisteredRoles();
        HashSet<Role> result = new HashSet<Role>(registered.size() + 1);
        result.addAll(registered);
        result.add(SecurityManagementUtils.createRole("admin"));
        return result;
    }

    public static Set<String> getRegisteredRoleNames() {
        Set registered = RoleRegistry.get().getRegisteredRoles();
        HashSet<String> result = new HashSet<String>(registered.size() + 1);
        result.addAll(SecurityManagementUtils.rolesToString(registered));
        result.add("admin");
        return result;
    }

    public static void populateGroupOrRoles(String name, Set<String> registeredRoles, Set<Group> groups, Set<Role> roles) {
        if (registeredRoles.contains(name)) {
            Role r = SecurityManagementUtils.createRole(name);
            if (null != r) {
                roles.add(r);
            }
        } else {
            Group g = SecurityManagementUtils.createGroup(name);
            if (null != g) {
                groups.add(g);
            }
        }
    }

    public static Set<String> rolesToString(Set<Role> roles) {
        if (null != roles && !roles.isEmpty()) {
            HashSet<String> result = new HashSet<String>(roles.size());
            for (Role role : roles) {
                result.add(role.getName());
            }
            return result;
        }
        return new HashSet<String>();
    }

    public static Set<String> groupsToString(Set<Group> groups) {
        if (null != groups && !groups.isEmpty()) {
            HashSet<String> result = new HashSet<String>(groups.size());
            for (Group group : groups) {
                result.add(group.getName());
            }
            return result;
        }
        return new HashSet<String>();
    }
}

