/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management;

import java.util.List;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.management.UberfireRoleManager;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.GroupNotFoundException;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class UberfireRoleManagerTest {
    @Mock
    UserSystemManager userSystemManager;
    private UberfireRoleManager tested;

    public static Role mockRole(String name) {
        Role role = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)role.getName()).thenReturn((Object)name);
        return role;
    }

    @Before
    public void setup() throws Exception {
        RoleRegistry.get().clear();
        RoleRegistry.get().registerRole("regRole1");
        RoleRegistry.get().registerRole("regRole2");
        RoleRegistry.get().registerRole("regRole3");
        this.tested = new UberfireRoleManager();
        this.tested.initialize(this.userSystemManager);
    }

    @Test
    public void testSearch() {
        GroupManager groupManager = (GroupManager)Mockito.mock(GroupManager.class);
        ((GroupManager)Mockito.doAnswer((Answer)new Answer<Group>(){

            public Group answer(InvocationOnMock invocationOnMock) throws Throwable {
                String name = (String)invocationOnMock.getArguments()[0];
                Group g = (Group)Mockito.mock(Group.class);
                Mockito.when((Object)g.getName()).thenReturn((Object)name);
                return g;
            }
        }).when((Object)groupManager)).get(Matchers.anyString());
        Mockito.when((Object)this.userSystemManager.groups()).thenReturn((Object)groupManager);
        AbstractEntityManager.SearchResponse response = this.tested.search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 10));
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)4L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)4L);
    }

    @Test
    public void testSearchRoleNotExists() {
        GroupManager groupManager = (GroupManager)Mockito.mock(GroupManager.class);
        ((GroupManager)Mockito.doAnswer((Answer)new Answer<Group>(){

            public Group answer(InvocationOnMock invocationOnMock) throws Throwable {
                String name = (String)invocationOnMock.getArguments()[0];
                Group g = (Group)Mockito.mock(Group.class);
                Mockito.when((Object)g.getName()).thenReturn((Object)name);
                return g;
            }
        }).when((Object)groupManager)).get(Matchers.anyString());
        ((GroupManager)Mockito.doThrow((Throwable)new GroupNotFoundException("admin")).when((Object)groupManager)).get("admin");
        Mockito.when((Object)this.userSystemManager.groups()).thenReturn((Object)groupManager);
        AbstractEntityManager.SearchResponse response = this.tested.search((AbstractEntityManager.SearchRequest)new SearchRequestImpl("", 1, 10));
        Assert.assertNotNull((Object)response);
        int total = response.getTotal();
        Assert.assertEquals((long)total, (long)3L);
        boolean hasNextPage = response.hasNextPage();
        Assert.assertEquals((Object)hasNextPage, (Object)false);
        List results = response.getResults();
        Assert.assertEquals((long)results.size(), (long)3L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGet() {
        this.tested.get("regRole1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCreate() {
        this.tested.create(UberfireRoleManagerTest.mockRole("regRole1"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUpdate() {
        this.tested.update(UberfireRoleManagerTest.mockRole("regRole1"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDelete() {
        this.tested.delete(new String[]{"regRole1"});
    }
}

