/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.SeekableByteChannel;

public class SeekableByteChannelFileBasedImpl
implements SeekableByteChannel {
    private final FileChannel channel;

    public SeekableByteChannelFileBasedImpl(FileChannel channel) {
        this.channel = (FileChannel)Preconditions.checkNotNull((String)"channel", (Object)channel);
    }

    @Override
    public long position() throws IOException {
        try {
            return this.channel.position();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        try {
            this.channel.position(newPosition);
            return this;
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long size() throws IOException {
        try {
            return this.channel.size();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        try {
            this.channel.truncate(size);
            return this;
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws java.io.IOException {
        try {
            return this.channel.read(dst);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(ByteBuffer src) throws java.io.IOException {
        try {
            return this.channel.write(src);
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws java.io.IOException {
        try {
            this.channel.close();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }
}

