/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.Dispatcher;
import twitter4j.DispatcherFactory;
import twitter4j.FilterQuery;
import twitter4j.HttpClient;
import twitter4j.HttpClientConfiguration;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.Logger;
import twitter4j.RawStreamListener;
import twitter4j.SiteStreamsImpl;
import twitter4j.SiteStreamsListener;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamBase;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamController;
import twitter4j.StreamListener;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.StringUtil;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;
import twitter4j.UserStream;
import twitter4j.UserStreamImpl;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;

class TwitterStreamImpl
extends TwitterBaseImpl
implements TwitterStream {
    private static final long serialVersionUID = 5621090317737561048L;
    private final HttpClient http;
    private static final Logger logger = Logger.getLogger(TwitterStreamImpl.class);
    private final List<ConnectionLifeCycleListener> lifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>(0);
    private TwitterStreamConsumer handler = null;
    private final String stallWarningsGetParam;
    private final HttpParameter stallWarningsParam;
    private static transient Dispatcher dispatcher;
    private static int numberOfHandlers;
    private final ArrayList<StreamListener> streamListeners = new ArrayList(0);
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;
    private static int count;

    TwitterStreamImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.http = HttpClientFactory.getInstance((HttpClientConfiguration)new StreamingReadTimeoutConfiguration(conf));
        this.http.addDefaultRequestHeader("Connection", "close");
        this.stallWarningsGetParam = "stall_warnings=" + (conf.isStallWarningsEnabled() ? "true" : "false");
        this.stallWarningsParam = new HttpParameter("stall_warnings", conf.isStallWarningsEnabled());
    }

    public void firehose(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFirehoseStream(count);
            }
        });
    }

    StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/firehose.json", count);
    }

    public void links(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getLinksStream(count);
            }
        });
    }

    StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/links.json", count);
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count)), this.stallWarningsParam}, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void retweet() {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getRetweetStream();
            }
        });
    }

    StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[]{this.stallWarningsParam}, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void sample() {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getSampleStream();
            }
        });
    }

    StatusStream getSampleStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json?" + this.stallWarningsGetParam, null, this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public void user() {
        this.user(null);
    }

    public void user(final String[] track) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.user){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getUserStream(track);
            }
        });
    }

    UserStream getUserStream(String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            params.add(this.stallWarningsParam);
            if (this.conf.isUserStreamRepliesAllEnabled()) {
                params.add(new HttpParameter("replies", "all"));
            }
            if (!this.conf.isUserStreamWithFollowingsEnabled()) {
                params.add(new HttpParameter("with", "user"));
            }
            if (track != null) {
                params.add(new HttpParameter("track", StringUtil.join((String[])track)));
            }
            return new UserStreamImpl(this.getDispatcher(), this.http.post(this.conf.getUserStreamBaseURL() + "user.json", params.toArray(new HttpParameter[params.size()]), this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    public StreamController site(final boolean withFollowings, final long[] follow) {
        this.ensureOAuthEnabled();
        this.ensureSiteStreamsListenerIsSet();
        final StreamController cs = new StreamController(this.http, this.auth);
        this.startHandler(new TwitterStreamConsumer(Mode.site){

            public StatusStream getStream() throws TwitterException {
                try {
                    return new SiteStreamsImpl(TwitterStreamImpl.this.getDispatcher(), TwitterStreamImpl.this.getSiteStream(withFollowings, follow), TwitterStreamImpl.this.conf, cs);
                }
                catch (IOException e) {
                    throw new TwitterException((Exception)e);
                }
            }
        });
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dispatcher getDispatcher() {
        if (null != dispatcher) return dispatcher;
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (null != dispatcher) return dispatcher;
            dispatcher = new DispatcherFactory(this.conf).getInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dispatcher;
        }
    }

    InputStream getSiteStream(boolean withFollowings, long[] follow) throws TwitterException {
        this.ensureOAuthEnabled();
        return this.http.post(this.conf.getSiteStreamBaseURL() + "site.json", new HttpParameter[]{new HttpParameter("with", withFollowings ? "followings" : "user"), new HttpParameter("follow", StringUtil.join((long[])follow)), this.stallWarningsParam}, this.auth, null).asStream();
    }

    public void filter(final FilterQuery query) {
        this.ensureAuthorizationEnabled();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(Mode.status){

            public StatusStream getStream() throws TwitterException {
                return TwitterStreamImpl.this.getFilterStream(query);
            }
        });
    }

    StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.getDispatcher(), this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", query.asHttpParameterArray(this.stallWarningsParam), this.auth, null), this.conf);
        }
        catch (IOException e) {
            throw new TwitterException((Exception)e);
        }
    }

    private void ensureStatusStreamListenerIsSet() {
        if (this.streamListeners.size() == 0) {
            throw new IllegalStateException("StatusListener is not set.");
        }
    }

    private void ensureSiteStreamsListenerIsSet() {
        if (this.getSiteStreamsListeners().length == 0 && this.getRawStreamListeners().length == 0) {
            throw new IllegalStateException("SiteStreamsListener is not set.");
        }
    }

    private synchronized void startHandler(TwitterStreamConsumer handler) {
        this.cleanUp();
        this.handler = handler;
        this.handler.start();
        ++numberOfHandlers;
    }

    public synchronized void cleanUp() {
        if (this.handler != null) {
            this.handler.close();
            --numberOfHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.cleanUp();
        Class<TwitterStreamImpl> clazz = TwitterStreamImpl.class;
        synchronized (TwitterStreamImpl.class) {
            if (0 == numberOfHandlers && dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public synchronized void addListener(StreamListener listener) {
        this.streamListeners.add(listener);
        this.updateListeners();
    }

    public synchronized void removeListener(StreamListener listener) {
        this.streamListeners.remove(listener);
        this.updateListeners();
    }

    public synchronized void clearListeners() {
        this.streamListeners.clear();
        this.updateListeners();
    }

    public synchronized void replaceListener(StreamListener toBeRemoved, StreamListener toBeAdded) {
        this.streamListeners.remove(toBeRemoved);
        this.streamListeners.add(toBeAdded);
        this.updateListeners();
    }

    private synchronized void updateListeners() {
        if (this.handler != null) {
            this.handler.updateListeners();
        }
    }

    private RawStreamListener[] getRawStreamListeners() {
        ArrayList<RawStreamListener> rawStreamListeners = new ArrayList<RawStreamListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof RawStreamListener)) continue;
            rawStreamListeners.add((RawStreamListener)streamListener);
        }
        return rawStreamListeners.toArray(new RawStreamListener[rawStreamListeners.size()]);
    }

    private SiteStreamsListener[] getSiteStreamsListeners() {
        ArrayList<SiteStreamsListener> siteStreamsListeners = new ArrayList<SiteStreamsListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof SiteStreamsListener)) continue;
            siteStreamsListeners.add((SiteStreamsListener)streamListener);
        }
        return siteStreamsListeners.toArray(new SiteStreamsListener[siteStreamsListeners.size()]);
    }

    private StatusListener[] getStatusListeners() {
        ArrayList<StatusListener> statusListeners = new ArrayList<StatusListener>();
        for (StreamListener streamListener : this.streamListeners) {
            if (!(streamListener instanceof StatusListener)) continue;
            statusListeners.add((StatusListener)streamListener);
        }
        return statusListeners.toArray(new StatusListener[statusListeners.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterStreamImpl that = (TwitterStreamImpl)o;
        if (this.handler != null ? !this.handler.equals(that.handler) : that.handler != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        if (this.lifeCycleListeners != null ? !this.lifeCycleListeners.equals(that.lifeCycleListeners) : that.lifeCycleListeners != null) {
            return false;
        }
        if (this.stallWarningsGetParam != null ? !this.stallWarningsGetParam.equals(that.stallWarningsGetParam) : that.stallWarningsGetParam != null) {
            return false;
        }
        if (this.stallWarningsParam != null ? !this.stallWarningsParam.equals((Object)that.stallWarningsParam) : that.stallWarningsParam != null) {
            return false;
        }
        return !(this.streamListeners != null ? !this.streamListeners.equals(that.streamListeners) : that.streamListeners != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
        result = 31 * result + (this.lifeCycleListeners != null ? this.lifeCycleListeners.hashCode() : 0);
        result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
        result = 31 * result + (this.stallWarningsGetParam != null ? this.stallWarningsGetParam.hashCode() : 0);
        result = 31 * result + (this.stallWarningsParam != null ? this.stallWarningsParam.hashCode() : 0);
        result = 31 * result + (this.streamListeners != null ? this.streamListeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TwitterStreamImpl{http=" + this.http + ", lifeCycleListeners=" + this.lifeCycleListeners + ", handler=" + this.handler + ", stallWarningsGetParam='" + this.stallWarningsGetParam + '\'' + ", stallWarningsParam=" + this.stallWarningsParam + ", streamListeners=" + this.streamListeners + '}';
    }

    static /* synthetic */ int access$104() {
        return ++count;
    }

    static {
        numberOfHandlers = 0;
        count = 0;
    }

    abstract class TwitterStreamConsumer
    extends Thread {
        private StatusStreamBase stream = null;
        private final String NAME = "Twitter Stream consumer-" + TwitterStreamImpl.access$104();
        private volatile boolean closed = false;
        private StreamListener[] streamListeners;
        private RawStreamListener[] rawStreamListeners;
        private final Mode mode;

        TwitterStreamConsumer(Mode mode) {
            this.mode = mode;
            this.updateListeners();
            this.setName(this.NAME + "[initializing]");
        }

        void updateListeners() {
            switch (this.mode) {
                case site: {
                    this.streamListeners = TwitterStreamImpl.this.getSiteStreamsListeners();
                    break;
                }
                default: {
                    this.streamListeners = TwitterStreamImpl.this.getStatusListeners();
                }
            }
            this.rawStreamListeners = TwitterStreamImpl.this.getRawStreamListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int timeToSleep = 0;
            boolean connected = false;
            block31: while (!this.closed) {
                try {
                    if (this.closed || null != this.stream) continue;
                    logger.info("Establishing connection.");
                    this.setStatus("[Establishing connection]");
                    this.stream = (StatusStreamBase)this.getStream();
                    connected = true;
                    logger.info("Connection established.");
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onConnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                    timeToSleep = 0;
                    logger.info("Receiving status stream.");
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        try {
                            this.stream.next(this.streamListeners, this.rawStreamListeners);
                        }
                        catch (IllegalStateException ise) {
                            logger.warn(ise.getMessage());
                            continue block31;
                        }
                        catch (TwitterException e) {
                            logger.info(e.getMessage());
                            this.stream.onException((Exception)((Object)e), this.streamListeners, this.rawStreamListeners);
                            throw e;
                        }
                        catch (Exception e) {
                            if (e instanceof NullPointerException || e.getMessage().equals("Inflater has been closed")) continue;
                            logger.info(e.getMessage());
                            this.stream.onException(e, this.streamListeners, this.rawStreamListeners);
                            this.closed = true;
                        }
                    }
                }
                catch (TwitterException te) {
                    logger.info(te.getMessage());
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        if (te.getStatusCode() == 403) {
                            logger.warn("This account is not in required role. ", te.getMessage());
                            this.closed = true;
                            for (StreamListener statusListener : this.streamListeners) {
                                statusListener.onException((Exception)((Object)te));
                            }
                            break;
                        }
                        if (te.getStatusCode() == 406) {
                            logger.warn("Parameter not accepted with the role. ", te.getMessage());
                            this.closed = true;
                            for (StreamListener statusListener : this.streamListeners) {
                                statusListener.onException((Exception)((Object)te));
                            }
                            break;
                        }
                        connected = false;
                        for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                            try {
                                listener.onDisconnect();
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                        }
                        if (te.getStatusCode() > 200) {
                            timeToSleep = 10000;
                        } else if (0 == timeToSleep) {
                            timeToSleep = 250;
                        }
                    }
                    if (te.getStatusCode() > 200 && timeToSleep < 10000) {
                        timeToSleep = 10000;
                    }
                    if (connected) {
                        for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                            try {
                                listener.onDisconnect();
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                        }
                    }
                    for (StreamListener statusListener : this.streamListeners) {
                        statusListener.onException((Exception)((Object)te));
                    }
                    if (!this.closed) {
                        logger.info("Waiting for " + timeToSleep + " milliseconds");
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    connected = false;
                }
            }
            if (this.stream != null && connected) {
                try {
                    this.stream.close();
                }
                catch (IOException ignore) {
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn(e.getMessage());
                }
                finally {
                    for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                }
            }
            for (ConnectionLifeCycleListener listener : TwitterStreamImpl.this.lifeCycleListeners) {
                try {
                    listener.onCleanUp();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                }
            }
        }

        public synchronized void close() {
            this.setStatus("[Disposing thread]");
            this.closed = true;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException ignore) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn(e.getMessage());
                }
            }
        }

        private void setStatus(String message) {
            String actualMessage = this.NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StatusStream getStream() throws TwitterException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        user,
        status,
        site;

    }
}

