/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import twitter4j.Authorization;
import twitter4j.BASE64Encoder;
import twitter4j.Configuration;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.OAuth2Token;
import twitter4j.TwitterException;

public class OAuth2Authorization
implements Authorization,
Serializable {
    private static final long serialVersionUID = -2895232598422218647L;
    private final String consumerKey;
    private final String consumerSecret;
    private OAuth2Token token;
    private final String oAuth2Scope;
    private final HttpClient http;
    private final String oAuth2TokenURL;
    private final String oAuth2InvalidateTokenURL;

    OAuth2Authorization(Configuration conf) {
        this.oAuth2Scope = conf.oAuth2Scope;
        this.http = conf.http;
        this.oAuth2TokenURL = conf.oAuth2TokenURL;
        this.oAuth2InvalidateTokenURL = conf.oAuth2InvalidateTokenURL;
        this.consumerKey = conf.oAuthConsumerKey != null ? conf.oAuthConsumerKey : "";
        String string = this.consumerSecret = conf.oAuthConsumerSecret != null ? conf.oAuthConsumerSecret : "";
        if (conf.oAuth2TokenType != null && conf.oAuth2AccessToken != null) {
            this.token = new OAuth2Token(conf.oAuth2TokenType, conf.oAuth2AccessToken);
        }
    }

    public static OAuth2AuthorizationBuilder newBuilder() {
        return new OAuth2AuthorizationBuilder();
    }

    public static OAuth2Authorization getInstance(String consumerKey, String consumerSecret) {
        return ((OAuth2AuthorizationBuilder)OAuth2Authorization.newBuilder().oAuthConsumer(consumerKey, consumerSecret)).build();
    }

    public static OAuth2Authorization getInstance() {
        return OAuth2Authorization.newBuilder().build();
    }

    public OAuth2Token getOAuth2Token() throws TwitterException {
        HttpResponse res;
        if (this.token != null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is already available.");
        }
        HttpParameter[] params = new HttpParameter[this.oAuth2Scope == null ? 1 : 2];
        params[0] = new HttpParameter("grant_type", "client_credentials");
        if (this.oAuth2Scope != null) {
            params[1] = new HttpParameter("scope", this.oAuth2Scope);
        }
        if ((res = this.http.post(this.oAuth2TokenURL, params, this, null)).getStatusCode() != 200) {
            throw new TwitterException("Obtaining OAuth 2 Bearer Token failed.", res);
        }
        this.token = new OAuth2Token(res);
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateOAuth2Token() throws TwitterException {
        if (this.token == null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is not available.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("access_token", this.token.getAccessToken())};
        OAuth2Token _token = this.token;
        boolean succeed = false;
        try {
            this.token = null;
            HttpResponse res = this.http.post(this.oAuth2InvalidateTokenURL, params, this, null);
            if (res.getStatusCode() != 200) {
                throw new TwitterException("Invalidating OAuth 2 Bearer Token failed.", res);
            }
            succeed = true;
        }
        finally {
            if (!succeed) {
                this.token = _token;
            }
        }
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        if (this.token == null) {
            String credentials;
            try {
                credentials = URLEncoder.encode(this.consumerKey, "UTF-8") + ":" + URLEncoder.encode(this.consumerSecret, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return "Basic " + BASE64Encoder.encode(credentials.getBytes());
        }
        return this.token.generateAuthorizationHeader();
    }

    @Override
    public boolean isEnabled() {
        return this.token != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Authorization that = (OAuth2Authorization)o;
        return Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey, this.consumerSecret, this.token);
    }

    public String toString() {
        return "OAuth2Authorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************', token=" + (this.token == null ? "null" : this.token.toString()) + '}';
    }

    static class OAuth2AuthorizationBuilder
    extends Configuration<OAuth2AuthorizationBuilder> {
        OAuth2AuthorizationBuilder() {
        }

        public OAuth2Authorization build() {
            return new OAuth2Authorization((Configuration)this.buildConfiguration());
        }
    }
}

