/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import twitter4j.HttpClient;
import twitter4j.HttpClientConfiguration;
import twitter4j.conf.ConfigurationContext;

public final class HttpClientFactory {
    private static final Constructor<?> HTTP_CLIENT_CONSTRUCTOR;
    private static final String HTTP_CLIENT_IMPLEMENTATION = "twitter4j.http.httpClient";
    private static final HashMap<HttpClientConfiguration, HttpClient> confClientMap;

    public static HttpClient getInstance() {
        return HttpClientFactory.getInstance(ConfigurationContext.getInstance().getHttpClientConfiguration());
    }

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        HttpClient client = confClientMap.get(conf);
        try {
            if (client == null) {
                client = (HttpClient)HTTP_CLIENT_CONSTRUCTOR.newInstance(conf);
                confClientMap.put(conf, client);
            }
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return client;
    }

    static {
        Class<?> clazz = null;
        String httpClientImpl = System.getProperty(HTTP_CLIENT_IMPLEMENTATION);
        if (httpClientImpl != null) {
            try {
                clazz = Class.forName(httpClientImpl);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("twitter4j.AlternativeHttpClientImpl");
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("twitter4j.HttpClientImpl");
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        try {
            HTTP_CLIENT_CONSTRUCTOR = clazz.getConstructor(HttpClientConfiguration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        confClientMap = new HashMap();
    }
}

