/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import twitter4j.HttpClientConfiguration;
import twitter4j.Logger;
import twitter4j.conf.Configuration;

class ConfigurationBase
implements Configuration,
Serializable {
    private static final long serialVersionUID = 6175546394599249696L;
    private boolean debug = false;
    private String user = null;
    private String password = null;
    private HttpClientConfiguration httpConf = new MyHttpClientConfiguration(null, null, null, -1, 20000, 120000, false, true);
    private int httpStreamingReadTimeout = 40000;
    private int httpRetryCount = 0;
    private int httpRetryIntervalSeconds = 5;
    private String oAuthConsumerKey = null;
    private String oAuthConsumerSecret = null;
    private String oAuthAccessToken = null;
    private String oAuthAccessTokenSecret = null;
    private String oAuth2TokenType;
    private String oAuth2AccessToken;
    private String oAuthRequestTokenURL = "https://api.twitter.com/oauth/request_token";
    private String oAuthAuthorizationURL = "https://api.twitter.com/oauth/authorize";
    private String oAuthAccessTokenURL = "https://api.twitter.com/oauth/access_token";
    private String oAuthAuthenticationURL = "https://api.twitter.com/oauth/authenticate";
    private String oAuth2TokenURL = "https://api.twitter.com/oauth2/token";
    private String oAuth2InvalidateTokenURL = "https://api.twitter.com/oauth2/invalidate_token";
    private String restBaseURL = "https://api.twitter.com/1.1/";
    private String streamBaseURL = "https://stream.twitter.com/1.1/";
    private String userStreamBaseURL = "https://userstream.twitter.com/1.1/";
    private String siteStreamBaseURL = "https://sitestream.twitter.com/1.1/";
    private String dispatcherImpl = "twitter4j.DispatcherImpl";
    private int asyncNumThreads = 1;
    private String loggerFactory = null;
    private long contributingTo = -1L;
    private boolean includeMyRetweetEnabled = true;
    private boolean trimUserEnabled = false;
    private boolean jsonStoreEnabled = false;
    private boolean mbeanEnabled = false;
    private boolean userStreamRepliesAllEnabled = false;
    private boolean userStreamWithFollowingsEnabled = true;
    private boolean stallWarningsEnabled = true;
    private boolean applicationOnlyAuthEnabled = false;
    private String mediaProvider = "TWITTER";
    private String mediaProviderAPIKey = null;
    private Properties mediaProviderParameters = null;
    private static final List<ConfigurationBase> instances = new ArrayList<ConfigurationBase>();

    protected ConfigurationBase() {
    }

    public void dumpConfiguration() {
        Logger log = Logger.getLogger(ConfigurationBase.class);
        if (this.debug) {
            Field[] fields;
            for (Field field : fields = ConfigurationBase.class.getDeclaredFields()) {
                try {
                    Object value = field.get(this);
                    String strValue = String.valueOf(value);
                    if (value != null && field.getName().matches("oAuthConsumerSecret|oAuthAccessTokenSecret|password")) {
                        strValue = String.valueOf(value).replaceAll(".", "*");
                    }
                    log.debug(field.getName() + ": " + strValue);
                }
                catch (IllegalAccessException ignore) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String user) {
        this.user = user;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    @Override
    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpConf;
    }

    protected final void setPassword(String password) {
        this.password = password;
    }

    protected final void setPrettyDebugEnabled(boolean prettyDebug) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), prettyDebug, this.httpConf.isGZIPEnabled());
    }

    protected final void setGZIPEnabled(boolean gzipEnabled) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), gzipEnabled);
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpConf = new MyHttpClientConfiguration(proxyHost, this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), proxyUser, this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), proxyPassword, this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), proxyPort, this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), connectionTimeout, this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), readTimeout, this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    @Override
    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
    }

    @Override
    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.oAuthConsumerSecret = oAuthConsumerSecret;
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
    }

    @Override
    public String getOAuth2TokenType() {
        return this.oAuth2TokenType;
    }

    protected final void setOAuth2TokenType(String oAuth2TokenType) {
        this.oAuth2TokenType = oAuth2TokenType;
    }

    @Override
    public String getOAuth2AccessToken() {
        return this.oAuth2AccessToken;
    }

    protected final void setOAuth2AccessToken(String oAuth2AccessToken) {
        this.oAuth2AccessToken = oAuth2AccessToken;
    }

    @Override
    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int asyncNumThreads) {
        this.asyncNumThreads = asyncNumThreads;
    }

    @Override
    public final long getContributingTo() {
        return this.contributingTo;
    }

    protected final void setContributingTo(long contributingTo) {
        this.contributingTo = contributingTo;
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
    }

    @Override
    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String streamBaseURL) {
        this.streamBaseURL = streamBaseURL;
    }

    @Override
    public String getUserStreamBaseURL() {
        return this.userStreamBaseURL;
    }

    protected final void setUserStreamBaseURL(String siteStreamBaseURL) {
        this.userStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getSiteStreamBaseURL() {
        return this.siteStreamBaseURL;
    }

    protected final void setSiteStreamBaseURL(String siteStreamBaseURL) {
        this.siteStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.oAuthRequestTokenURL = oAuthRequestTokenURL;
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
    }

    @Override
    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.oAuthAuthenticationURL = oAuthAuthenticationURL;
    }

    @Override
    public String getOAuth2TokenURL() {
        return this.oAuth2TokenURL;
    }

    protected final void setOAuth2TokenURL(String oAuth2TokenURL) {
        this.oAuth2TokenURL = oAuth2TokenURL;
    }

    @Override
    public String getOAuth2InvalidateTokenURL() {
        return this.oAuth2InvalidateTokenURL;
    }

    protected final void setOAuth2InvalidateTokenURL(String oAuth2InvalidateTokenURL) {
        this.oAuth2InvalidateTokenURL = oAuth2InvalidateTokenURL;
    }

    @Override
    public String getDispatcherImpl() {
        return this.dispatcherImpl;
    }

    protected final void setDispatcherImpl(String dispatcherImpl) {
        this.dispatcherImpl = dispatcherImpl;
    }

    @Override
    public String getLoggerFactory() {
        return this.loggerFactory;
    }

    protected final void setLoggerFactory(String loggerImpl) {
        this.loggerFactory = loggerImpl;
    }

    @Override
    public boolean isIncludeMyRetweetEnabled() {
        return this.includeMyRetweetEnabled;
    }

    public void setIncludeMyRetweetEnabled(boolean enabled) {
        this.includeMyRetweetEnabled = enabled;
    }

    @Override
    public boolean isTrimUserEnabled() {
        return this.trimUserEnabled;
    }

    public void setTrimUserEnabled(boolean enabled) {
        this.trimUserEnabled = enabled;
    }

    @Override
    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean enabled) {
        this.jsonStoreEnabled = enabled;
    }

    @Override
    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean enabled) {
        this.mbeanEnabled = enabled;
    }

    @Override
    public boolean isUserStreamRepliesAllEnabled() {
        return this.userStreamRepliesAllEnabled;
    }

    @Override
    public boolean isUserStreamWithFollowingsEnabled() {
        return this.userStreamWithFollowingsEnabled;
    }

    protected final void setUserStreamRepliesAllEnabled(boolean enabled) {
        this.userStreamRepliesAllEnabled = enabled;
    }

    protected final void setUserStreamWithFollowingsEnabled(boolean enabled) {
        this.userStreamWithFollowingsEnabled = enabled;
    }

    @Override
    public boolean isStallWarningsEnabled() {
        return this.stallWarningsEnabled;
    }

    protected final void setStallWarningsEnabled(boolean stallWarningsEnabled) {
        this.stallWarningsEnabled = stallWarningsEnabled;
    }

    @Override
    public boolean isApplicationOnlyAuthEnabled() {
        return this.applicationOnlyAuthEnabled;
    }

    protected final void setApplicationOnlyAuthEnabled(boolean applicationOnlyAuthEnabled) {
        this.applicationOnlyAuthEnabled = applicationOnlyAuthEnabled;
    }

    @Override
    public String getMediaProvider() {
        return this.mediaProvider;
    }

    protected final void setMediaProvider(String mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    @Override
    public String getMediaProviderAPIKey() {
        return this.mediaProviderAPIKey;
    }

    protected final void setMediaProviderAPIKey(String mediaProviderAPIKey) {
        this.mediaProviderAPIKey = mediaProviderAPIKey;
    }

    @Override
    public Properties getMediaProviderParameters() {
        return this.mediaProviderParameters;
    }

    protected final void setMediaProviderParameters(Properties props) {
        this.mediaProviderParameters = props;
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return "https://" + hostAndLater;
        }
        return "http://" + hostAndLater;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationBase that = (ConfigurationBase)o;
        if (this.applicationOnlyAuthEnabled != that.applicationOnlyAuthEnabled) {
            return false;
        }
        if (this.asyncNumThreads != that.asyncNumThreads) {
            return false;
        }
        if (this.contributingTo != that.contributingTo) {
            return false;
        }
        if (this.debug != that.debug) {
            return false;
        }
        if (this.httpRetryCount != that.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != that.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != that.httpStreamingReadTimeout) {
            return false;
        }
        if (this.includeMyRetweetEnabled != that.includeMyRetweetEnabled) {
            return false;
        }
        if (this.jsonStoreEnabled != that.jsonStoreEnabled) {
            return false;
        }
        if (this.mbeanEnabled != that.mbeanEnabled) {
            return false;
        }
        if (this.stallWarningsEnabled != that.stallWarningsEnabled) {
            return false;
        }
        if (this.trimUserEnabled != that.trimUserEnabled) {
            return false;
        }
        if (this.userStreamRepliesAllEnabled != that.userStreamRepliesAllEnabled) {
            return false;
        }
        if (this.userStreamWithFollowingsEnabled != that.userStreamWithFollowingsEnabled) {
            return false;
        }
        if (this.dispatcherImpl != null ? !this.dispatcherImpl.equals(that.dispatcherImpl) : that.dispatcherImpl != null) {
            return false;
        }
        if (this.httpConf != null ? !this.httpConf.equals(that.httpConf) : that.httpConf != null) {
            return false;
        }
        if (this.loggerFactory != null ? !this.loggerFactory.equals(that.loggerFactory) : that.loggerFactory != null) {
            return false;
        }
        if (this.mediaProvider != null ? !this.mediaProvider.equals(that.mediaProvider) : that.mediaProvider != null) {
            return false;
        }
        if (this.mediaProviderAPIKey != null ? !this.mediaProviderAPIKey.equals(that.mediaProviderAPIKey) : that.mediaProviderAPIKey != null) {
            return false;
        }
        if (this.mediaProviderParameters != null ? !this.mediaProviderParameters.equals(that.mediaProviderParameters) : that.mediaProviderParameters != null) {
            return false;
        }
        if (this.oAuth2AccessToken != null ? !this.oAuth2AccessToken.equals(that.oAuth2AccessToken) : that.oAuth2AccessToken != null) {
            return false;
        }
        if (this.oAuth2InvalidateTokenURL != null ? !this.oAuth2InvalidateTokenURL.equals(that.oAuth2InvalidateTokenURL) : that.oAuth2InvalidateTokenURL != null) {
            return false;
        }
        if (this.oAuth2TokenType != null ? !this.oAuth2TokenType.equals(that.oAuth2TokenType) : that.oAuth2TokenType != null) {
            return false;
        }
        if (this.oAuth2TokenURL != null ? !this.oAuth2TokenURL.equals(that.oAuth2TokenURL) : that.oAuth2TokenURL != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(that.oAuthAccessToken) : that.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenSecret != null ? !this.oAuthAccessTokenSecret.equals(that.oAuthAccessTokenSecret) : that.oAuthAccessTokenSecret != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(that.oAuthAccessTokenURL) : that.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAuthenticationURL != null ? !this.oAuthAuthenticationURL.equals(that.oAuthAuthenticationURL) : that.oAuthAuthenticationURL != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(that.oAuthAuthorizationURL) : that.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthConsumerKey != null ? !this.oAuthConsumerKey.equals(that.oAuthConsumerKey) : that.oAuthConsumerKey != null) {
            return false;
        }
        if (this.oAuthConsumerSecret != null ? !this.oAuthConsumerSecret.equals(that.oAuthConsumerSecret) : that.oAuthConsumerSecret != null) {
            return false;
        }
        if (this.oAuthRequestTokenURL != null ? !this.oAuthRequestTokenURL.equals(that.oAuthRequestTokenURL) : that.oAuthRequestTokenURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(that.restBaseURL) : that.restBaseURL != null) {
            return false;
        }
        if (this.siteStreamBaseURL != null ? !this.siteStreamBaseURL.equals(that.siteStreamBaseURL) : that.siteStreamBaseURL != null) {
            return false;
        }
        if (this.streamBaseURL != null ? !this.streamBaseURL.equals(that.streamBaseURL) : that.streamBaseURL != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.userStreamBaseURL != null ? !this.userStreamBaseURL.equals(that.userStreamBaseURL) : that.userStreamBaseURL != null);
    }

    public int hashCode() {
        int result = this.debug ? 1 : 0;
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.httpConf != null ? this.httpConf.hashCode() : 0);
        result = 31 * result + this.httpStreamingReadTimeout;
        result = 31 * result + this.httpRetryCount;
        result = 31 * result + this.httpRetryIntervalSeconds;
        result = 31 * result + (this.oAuthConsumerKey != null ? this.oAuthConsumerKey.hashCode() : 0);
        result = 31 * result + (this.oAuthConsumerSecret != null ? this.oAuthConsumerSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenSecret != null ? this.oAuthAccessTokenSecret.hashCode() : 0);
        result = 31 * result + (this.oAuth2TokenType != null ? this.oAuth2TokenType.hashCode() : 0);
        result = 31 * result + (this.oAuth2AccessToken != null ? this.oAuth2AccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthRequestTokenURL != null ? this.oAuthRequestTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthenticationURL != null ? this.oAuthAuthenticationURL.hashCode() : 0);
        result = 31 * result + (this.oAuth2TokenURL != null ? this.oAuth2TokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuth2InvalidateTokenURL != null ? this.oAuth2InvalidateTokenURL.hashCode() : 0);
        result = 31 * result + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        result = 31 * result + (this.streamBaseURL != null ? this.streamBaseURL.hashCode() : 0);
        result = 31 * result + (this.userStreamBaseURL != null ? this.userStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.siteStreamBaseURL != null ? this.siteStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.dispatcherImpl != null ? this.dispatcherImpl.hashCode() : 0);
        result = 31 * result + this.asyncNumThreads;
        result = 31 * result + (this.loggerFactory != null ? this.loggerFactory.hashCode() : 0);
        result = 31 * result + (int)(this.contributingTo ^ this.contributingTo >>> 32);
        result = 31 * result + (this.includeMyRetweetEnabled ? 1 : 0);
        result = 31 * result + (this.trimUserEnabled ? 1 : 0);
        result = 31 * result + (this.jsonStoreEnabled ? 1 : 0);
        result = 31 * result + (this.mbeanEnabled ? 1 : 0);
        result = 31 * result + (this.userStreamRepliesAllEnabled ? 1 : 0);
        result = 31 * result + (this.userStreamWithFollowingsEnabled ? 1 : 0);
        result = 31 * result + (this.stallWarningsEnabled ? 1 : 0);
        result = 31 * result + (this.applicationOnlyAuthEnabled ? 1 : 0);
        result = 31 * result + (this.mediaProvider != null ? this.mediaProvider.hashCode() : 0);
        result = 31 * result + (this.mediaProviderAPIKey != null ? this.mediaProviderAPIKey.hashCode() : 0);
        result = 31 * result + (this.mediaProviderParameters != null ? this.mediaProviderParameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigurationBase{debug=" + this.debug + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", httpConf=" + this.httpConf + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", oAuthConsumerKey='" + this.oAuthConsumerKey + '\'' + ", oAuthConsumerSecret='" + this.oAuthConsumerSecret + '\'' + ", oAuthAccessToken='" + this.oAuthAccessToken + '\'' + ", oAuthAccessTokenSecret='" + this.oAuthAccessTokenSecret + '\'' + ", oAuth2TokenType='" + this.oAuth2TokenType + '\'' + ", oAuth2AccessToken='" + this.oAuth2AccessToken + '\'' + ", oAuthRequestTokenURL='" + this.oAuthRequestTokenURL + '\'' + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAuthenticationURL='" + this.oAuthAuthenticationURL + '\'' + ", oAuth2TokenURL='" + this.oAuth2TokenURL + '\'' + ", oAuth2InvalidateTokenURL='" + this.oAuth2InvalidateTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", streamBaseURL='" + this.streamBaseURL + '\'' + ", userStreamBaseURL='" + this.userStreamBaseURL + '\'' + ", siteStreamBaseURL='" + this.siteStreamBaseURL + '\'' + ", dispatcherImpl='" + this.dispatcherImpl + '\'' + ", asyncNumThreads=" + this.asyncNumThreads + ", loggerFactory='" + this.loggerFactory + '\'' + ", contributingTo=" + this.contributingTo + ", includeMyRetweetEnabled=" + this.includeMyRetweetEnabled + ", trimUserEnabled=" + this.trimUserEnabled + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", userStreamRepliesAllEnabled=" + this.userStreamRepliesAllEnabled + ", userStreamWithFollowingsEnabled=" + this.userStreamWithFollowingsEnabled + ", stallWarningsEnabled=" + this.stallWarningsEnabled + ", applicationOnlyAuthEnabled=" + this.applicationOnlyAuthEnabled + ", mediaProvider='" + this.mediaProvider + '\'' + ", mediaProviderAPIKey='" + this.mediaProviderAPIKey + '\'' + ", mediaProviderParameters=" + this.mediaProviderParameters + '}';
    }

    private static void cacheInstance(ConfigurationBase conf) {
        if (!instances.contains(conf)) {
            instances.add(conf);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int index = instances.indexOf(configurationBase);
        if (index == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(index);
    }

    protected Object readResolve() throws ObjectStreamException {
        return ConfigurationBase.getInstance(this);
    }

    class MyHttpClientConfiguration
    implements HttpClientConfiguration,
    Serializable {
        private static final long serialVersionUID = 8226866124868861058L;
        private String httpProxyHost = null;
        private String httpProxyUser = null;
        private String httpProxyPassword = null;
        private int httpProxyPort = -1;
        private int httpConnectionTimeout = 20000;
        private int httpReadTimeout = 120000;
        private boolean prettyDebug = false;
        private boolean gzipEnabled = true;

        MyHttpClientConfiguration(String httpProxyHost, String httpProxyUser, String httpProxyPassword, int httpProxyPort, int httpConnectionTimeout, int httpReadTimeout, boolean prettyDebug, boolean gzipEnabled) {
            this.httpProxyHost = httpProxyHost;
            this.httpProxyUser = httpProxyUser;
            this.httpProxyPassword = httpProxyPassword;
            this.httpProxyPort = httpProxyPort;
            this.httpConnectionTimeout = httpConnectionTimeout;
            this.httpReadTimeout = httpReadTimeout;
            this.prettyDebug = prettyDebug;
            this.gzipEnabled = gzipEnabled;
        }

        @Override
        public String getHttpProxyHost() {
            return this.httpProxyHost;
        }

        @Override
        public int getHttpProxyPort() {
            return this.httpProxyPort;
        }

        @Override
        public String getHttpProxyUser() {
            return this.httpProxyUser;
        }

        @Override
        public String getHttpProxyPassword() {
            return this.httpProxyPassword;
        }

        @Override
        public int getHttpConnectionTimeout() {
            return this.httpConnectionTimeout;
        }

        @Override
        public int getHttpReadTimeout() {
            return this.httpReadTimeout;
        }

        @Override
        public int getHttpRetryCount() {
            return ConfigurationBase.this.httpRetryCount;
        }

        @Override
        public int getHttpRetryIntervalSeconds() {
            return ConfigurationBase.this.httpRetryIntervalSeconds;
        }

        @Override
        public boolean isPrettyDebugEnabled() {
            return this.prettyDebug;
        }

        @Override
        public boolean isGZIPEnabled() {
            return this.gzipEnabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyHttpClientConfiguration that = (MyHttpClientConfiguration)o;
            if (this.gzipEnabled != that.gzipEnabled) {
                return false;
            }
            if (this.httpConnectionTimeout != that.httpConnectionTimeout) {
                return false;
            }
            if (this.httpProxyPort != that.httpProxyPort) {
                return false;
            }
            if (this.httpReadTimeout != that.httpReadTimeout) {
                return false;
            }
            if (this.prettyDebug != that.prettyDebug) {
                return false;
            }
            if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
                return false;
            }
            if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(that.httpProxyPassword) : that.httpProxyPassword != null) {
                return false;
            }
            return !(this.httpProxyUser != null ? !this.httpProxyUser.equals(that.httpProxyUser) : that.httpProxyUser != null);
        }

        public int hashCode() {
            int result = this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0;
            result = 31 * result + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
            result = 31 * result + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
            result = 31 * result + this.httpProxyPort;
            result = 31 * result + this.httpConnectionTimeout;
            result = 31 * result + this.httpReadTimeout;
            result = 31 * result + (this.prettyDebug ? 1 : 0);
            result = 31 * result + (this.gzipEnabled ? 1 : 0);
            return result;
        }

        public String toString() {
            return "MyHttpClientConfiguration{httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + '}';
        }
    }
}

