/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import twitter4j.conf.ConfigurationContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectFactoryUtil {
    private static final boolean JSON_STORE_ENABLED = ConfigurationContext.getInstance().isJSONStoreEnabled();
    private static final Method CLEAR_THREAD_LOCAL_MAP;
    private static final Method REGISTER_JSON_OBJECT;
    static /* synthetic */ Class class$twitter4j$json$DataObjectFactory;

    private DataObjectFactoryUtil() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static void clearThreadLocalMap() {
        if (JSON_STORE_ENABLED) {
            try {
                CLEAR_THREAD_LOCAL_MAP.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static <T> T registerJSONObject(T key, Object json) {
        if (JSON_STORE_ENABLED) {
            try {
                return (T)REGISTER_JSON_OBJECT.invoke(null, key, json);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        Method[] methods = (class$twitter4j$json$DataObjectFactory == null ? (class$twitter4j$json$DataObjectFactory = DataObjectFactoryUtil.class$("twitter4j.json.DataObjectFactory")) : class$twitter4j$json$DataObjectFactory).getDeclaredMethods();
        Method clearThreadLocalMap = null;
        Method registerJSONObject = null;
        for (Method method : methods) {
            if (method.getName().equals("clearThreadLocalMap")) {
                clearThreadLocalMap = method;
                clearThreadLocalMap.setAccessible(true);
                continue;
            }
            if (!method.getName().equals("registerJSONObject")) continue;
            registerJSONObject = method;
            registerJSONObject.setAccessible(true);
        }
        if (null == clearThreadLocalMap || null == registerJSONObject) {
            throw new AssertionError();
        }
        CLEAR_THREAD_LOCAL_MAP = clearThreadLocalMap;
        REGISTER_JSON_OBJECT = registerJSONObject;
    }
}

