/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.AbstractStreamImplementation;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStreamListener;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

class StatusStreamImpl
extends AbstractStreamImplementation
implements StatusStream {
    protected String line;
    protected StreamListener[] listeners;

    StatusStreamImpl(Dispatcher dispatcher, InputStream stream) throws IOException {
        super(dispatcher, stream);
    }

    StatusStreamImpl(Dispatcher dispatcher, HttpResponse response) throws IOException {
        super(dispatcher, response);
    }

    public void next(StatusListener listener) throws TwitterException {
        StreamListener[] list = new StreamListener[]{listener};
        this.listeners = list;
        this.handleNextElement();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listeners = listeners;
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        DataObjectFactoryUtil.clearThreadLocalMap();
        this.line = line;
        return line;
    }

    protected void onStatus(JSONObject json) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onStatus(this.asStatus(json));
        }
    }

    protected void onDelete(JSONObject json) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            JSONObject deletionNotice = json.getJSONObject("delete");
            if (deletionNotice.has("status")) {
                ((StatusListener)listener).onDeletionNotice(new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
                continue;
            }
            JSONObject directMessage = deletionNotice.getJSONObject("direct_message");
            ((UserStreamListener)listener).onDeletionNotice(ParseUtil.getInt("id", directMessage), ParseUtil.getInt("user_id", directMessage));
        }
    }

    protected void onLimit(JSONObject json) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
        }
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException, JSONException {
        JSONObject scrubGeo = json.getJSONObject("scrub_geo");
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((StatusListener)listener).onScrubGeo(ParseUtil.getInt("user_id", scrubGeo), ParseUtil.getLong("up_to_status_id", scrubGeo));
        }
    }

    public void onException(Exception e) {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            listener.onException(e);
        }
    }
}

