/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import twitter4j.Device;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.Paging;
import twitter4j.ProfileImage;
import twitter4j.Query;
import twitter4j.RateLimitStatusListener;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.TwitterListener;
import twitter4j.TwitterMethod;
import twitter4j.TwitterOAuthSupportBase;
import twitter4j.api.AccountMethodsAsync;
import twitter4j.api.BlockMethodsAsync;
import twitter4j.api.DirectMessageMethodsAsync;
import twitter4j.api.FavoriteMethodsAsync;
import twitter4j.api.FriendsFollowersMethodsAsync;
import twitter4j.api.FriendshipMethodsAsync;
import twitter4j.api.GeoMethodsAsync;
import twitter4j.api.HelpMethodsAsync;
import twitter4j.api.LegalResourcesAsync;
import twitter4j.api.ListMembersMethodsAsync;
import twitter4j.api.ListMethodsAsync;
import twitter4j.api.ListSubscribersMethodsAsync;
import twitter4j.api.LocalTrendsMethodsAsync;
import twitter4j.api.NewTwitterMethodsAsync;
import twitter4j.api.NotificationMethodsAsync;
import twitter4j.api.SavedSearchesMethodsAsync;
import twitter4j.api.SearchMethodsAsync;
import twitter4j.api.SpamReportingMethodsAsync;
import twitter4j.api.StatusMethodsAsync;
import twitter4j.api.TimelineMethodsAsync;
import twitter4j.api.TrendsMethodsAsync;
import twitter4j.api.UserMethodsAsync;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.RequestToken;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;
import twitter4j.internal.http.HttpResponseEvent;

public class AsyncTwitter
extends TwitterOAuthSupportBase
implements Serializable,
SearchMethodsAsync,
TrendsMethodsAsync,
TimelineMethodsAsync,
StatusMethodsAsync,
UserMethodsAsync,
ListMethodsAsync,
ListMembersMethodsAsync,
ListSubscribersMethodsAsync,
DirectMessageMethodsAsync,
FriendshipMethodsAsync,
FriendsFollowersMethodsAsync,
AccountMethodsAsync,
FavoriteMethodsAsync,
NotificationMethodsAsync,
BlockMethodsAsync,
SpamReportingMethodsAsync,
SavedSearchesMethodsAsync,
LocalTrendsMethodsAsync,
GeoMethodsAsync,
LegalResourcesAsync,
NewTwitterMethodsAsync,
HelpMethodsAsync {
    private static final long serialVersionUID = -2008667933225051907L;
    private final Twitter twitter;
    private final TwitterListener listener;
    private static transient Dispatcher dispatcher;
    private boolean shutdown = false;

    public AsyncTwitter(String screenName, String password, TwitterListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.twitter = new TwitterFactory(ConfigurationContext.getInstance()).getInstance(screenName, password);
        this.listener = listener;
    }

    AsyncTwitter(Configuration conf, Authorization auth, TwitterListener listener) {
        super(conf, auth);
        this.twitter = new TwitterFactory(conf).getInstance(auth);
        this.listener = listener;
    }

    public String getScreenName() throws TwitterException, IllegalStateException {
        return this.twitter.getScreenName();
    }

    public int getId() throws TwitterException, IllegalStateException {
        return this.twitter.getId();
    }

    public void search(final Query query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.searched(AsyncTwitter.this.twitter.search(query));
            }
        });
    }

    public void getTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotTrends(AsyncTwitter.this.twitter.getTrends());
            }
        });
    }

    public void getCurrentTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.twitter.getCurrentTrends());
            }
        });
    }

    public void getCurrentTrends(final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CURRENT_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotCurrentTrends(AsyncTwitter.this.twitter.getCurrentTrends(excludeHashTags));
            }
        });
    }

    public void getDailyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.twitter.getDailyTrends());
            }
        });
    }

    public void getDailyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DAILY_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotDailyTrends(AsyncTwitter.this.twitter.getDailyTrends(date, excludeHashTags));
            }
        });
    }

    public void getWeeklyTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.twitter.getWeeklyTrends());
            }
        });
    }

    public void getWeeklyTrends(final Date date, final boolean excludeHashTags) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.WEEKLY_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotWeeklyTrends(AsyncTwitter.this.twitter.getWeeklyTrends(date, excludeHashTags));
            }
        });
    }

    public void getPublicTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PUBLIC_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotPublicTimeline(AsyncTwitter.this.twitter.getPublicTimeline());
            }
        });
    }

    public void getHomeTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotHomeTimeline(AsyncTwitter.this.twitter.getHomeTimeline());
            }
        });
    }

    public void getHomeTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotHomeTimeline(AsyncTwitter.this.twitter.getHomeTimeline(paging));
            }
        });
    }

    public void getFriendsTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.twitter.getFriendsTimeline());
            }
        });
    }

    public void getFriendsTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsTimeline(AsyncTwitter.this.twitter.getFriendsTimeline(paging));
            }
        });
    }

    public void getUserTimeline(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline(screenName, paging));
            }
        });
    }

    public void getUserTimeline(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline(userId, paging));
            }
        });
    }

    public void getUserTimeline(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline(paging));
            }
        });
    }

    public void getUserTimeline(String screenName) {
        this.getUserTimeline(screenName, new Paging());
    }

    public void getUserTimeline(int userId) {
        this.getUserTimeline(userId, new Paging());
    }

    public void getUserTimeline() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_TIMELINE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserTimeline(AsyncTwitter.this.twitter.getUserTimeline());
            }
        });
    }

    public void getMentions() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.twitter.getMentions());
            }
        });
    }

    public void getMentions(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MENTIONS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotMentions(AsyncTwitter.this.twitter.getMentions(paging));
            }
        });
    }

    public void getRetweetedByMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByMe(AsyncTwitter.this.twitter.getRetweetedByMe());
            }
        });
    }

    public void getRetweetedByMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByMe(AsyncTwitter.this.twitter.getRetweetedByMe(paging));
            }
        });
    }

    public void getRetweetedToMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedToMe(AsyncTwitter.this.twitter.getRetweetedToMe());
            }
        });
    }

    public void getRetweetedToMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedToMe(AsyncTwitter.this.twitter.getRetweetedToMe(paging));
            }
        });
    }

    public void getRetweetsOfMe() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetsOfMe(AsyncTwitter.this.twitter.getRetweetsOfMe());
            }
        });
    }

    public void getRetweetsOfMe(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetsOfMe(AsyncTwitter.this.twitter.getRetweetsOfMe(paging));
            }
        });
    }

    public void getRetweetedByUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByUser(AsyncTwitter.this.twitter.getRetweetedByUser(screenName, paging));
            }
        });
    }

    public void getRetweetedByUser(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByUser(AsyncTwitter.this.twitter.getRetweetedByUser(userId, paging));
            }
        });
    }

    public void getRetweetedToUser(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedToUser(AsyncTwitter.this.twitter.getRetweetedToUser(screenName, paging));
            }
        });
    }

    public void getRetweetedToUser(final int userId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_TO_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedToUser(AsyncTwitter.this.twitter.getRetweetedToUser(userId, paging));
            }
        });
    }

    public void showStatus(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotShowStatus(AsyncTwitter.this.twitter.showStatus(id));
            }
        });
    }

    public void updateStatus(final String status) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus(status));
            }
        });
    }

    public void updateStatus(final String status, final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus(status, location));
            }
        });
    }

    public void updateStatus(final String status, final long inReplyToStatusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus(status, inReplyToStatusId));
            }
        });
    }

    public void updateStatus(final String status, final long inReplyToStatusId, final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus(status, inReplyToStatusId, location));
            }
        });
    }

    public void updateStatus(final StatusUpdate latestStatus) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedStatus(AsyncTwitter.this.twitter.updateStatus(latestStatus));
            }
        });
    }

    public void destroyStatus(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedStatus(AsyncTwitter.this.twitter.destroyStatus(statusId));
            }
        });
    }

    public void retweetStatus(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.retweetedStatus(AsyncTwitter.this.twitter.retweetStatus(statusId));
            }
        });
    }

    public void getRetweets(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweets(AsyncTwitter.this.twitter.getRetweets(statusId));
            }
        });
    }

    public void getRetweetedBy(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedBy(AsyncTwitter.this.twitter.getRetweetedBy(statusId));
            }
        });
    }

    public void getRetweetedBy(final long statusId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedBy(AsyncTwitter.this.twitter.getRetweetedBy(statusId, paging));
            }
        });
    }

    public void getRetweetedByIDs(final long statusId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByIDs(AsyncTwitter.this.twitter.getRetweetedByIDs(statusId));
            }
        });
    }

    public void getRetweetedByIDs(final long statusId, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RETWEETED_BY_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRetweetedByIDs(AsyncTwitter.this.twitter.getRetweetedByIDs(statusId, paging));
            }
        });
    }

    public void showUser(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserDetail(AsyncTwitter.this.twitter.showUser(screenName));
            }
        });
    }

    public void showUser(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_USER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserDetail(AsyncTwitter.this.twitter.showUser(userId));
            }
        });
    }

    public void lookupUsers(final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.lookedupUsers(AsyncTwitter.this.twitter.lookupUsers(screenNames));
            }
        });
    }

    public void lookupUsers(final int[] ids) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.lookedupUsers(AsyncTwitter.this.twitter.lookupUsers(ids));
            }
        });
    }

    public void searchUsers(final String query, final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH_USERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.searchedUser(AsyncTwitter.this.twitter.searchUsers(query, page));
            }
        });
    }

    public void getSuggestedUserCategories() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SUGGESTED_USER_CATEGORIES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotSuggestedUserCategories(AsyncTwitter.this.twitter.getSuggestedUserCategories());
            }
        });
    }

    public void getUserSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_SUGGESTIONS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserSuggestions(AsyncTwitter.this.twitter.getUserSuggestions(categorySlug));
            }
        });
    }

    public void getMemberSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.MEMBER_SUGGESTIONS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotMemberSuggestions(AsyncTwitter.this.twitter.getMemberSuggestions(categorySlug));
            }
        });
    }

    public void getProfileImage(final String screenName, final ProfileImage.ImageSize size) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PROFILE_IMAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotProfileImage(AsyncTwitter.this.twitter.getProfileImage(screenName, size));
            }
        });
    }

    public void getAccountTotals() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ACCOUNT_TOTALS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAccountTotals(AsyncTwitter.this.twitter.getAccountTotals());
            }
        });
    }

    public void getAccountSettings() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ACCOUNT_SETTINGS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAccountSettings(AsyncTwitter.this.twitter.getAccountSettings());
            }
        });
    }

    public void getFriendsStatuses() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses());
            }
        });
    }

    public void getFriendsStatuses(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses(cursor));
            }
        });
    }

    public void getFriendsStatuses(String screenName) {
        this.getFriendsStatuses(screenName, -1L);
    }

    public void getFriendsStatuses(int userId) {
        this.getFriendsStatuses(userId, -1L);
    }

    public void getFriendsStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses(screenName, cursor));
            }
        });
    }

    public void getFriendsStatuses(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsStatuses(AsyncTwitter.this.twitter.getFriendsStatuses(userId, cursor));
            }
        });
    }

    public void getFollowersStatuses() {
        this.getFollowersStatuses(-1L);
    }

    public void getFollowersStatuses(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses(cursor));
            }
        });
    }

    public void getFollowersStatuses(String screenName) {
        this.getFollowersStatuses(screenName, -1L);
    }

    public void getFollowersStatuses(int userId) {
        this.getFollowersStatuses(userId, -1L);
    }

    public void getFollowersStatuses(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses(screenName, cursor));
            }
        });
    }

    public void getFollowersStatuses(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersStatuses(AsyncTwitter.this.twitter.getFollowersStatuses(userId, cursor));
            }
        });
    }

    public void createUserList(final String listName, final boolean isPublicList, final String description) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_USER_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdUserList(AsyncTwitter.this.twitter.createUserList(listName, isPublicList, description));
            }
        });
    }

    public void updateUserList(final int listId, final String newListName, final boolean isPublicList, final String newDescription) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedUserList(AsyncTwitter.this.twitter.updateUserList(listId, newListName, isPublicList, newDescription));
            }
        });
    }

    public void getUserLists(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LISTS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserLists(AsyncTwitter.this.twitter.getUserLists(listOwnerScreenName, cursor));
            }
        });
    }

    public void showUserList(final String listOwnerScreenName, final int id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotShowUserList(AsyncTwitter.this.twitter.showUserList(listOwnerScreenName, id));
            }
        });
    }

    public void destroyUserList(final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_USER_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedUserList(AsyncTwitter.this.twitter.destroyUserList(listId));
            }
        });
    }

    public void getUserListStatuses(final String listOwnerScreenName, final int id, final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserListStatuses(AsyncTwitter.this.twitter.getUserListStatuses(listOwnerScreenName, id, paging));
            }
        });
    }

    public void getUserListMemberships(final String listMemberScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserListMemberships(AsyncTwitter.this.twitter.getUserListMemberships(listMemberScreenName, cursor));
            }
        });
    }

    public void getUserListSubscriptions(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.USER_LIST_SUBSCRIPTIONS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserListSubscriptions(AsyncTwitter.this.twitter.getUserListSubscriptions(listOwnerScreenName, cursor));
            }
        });
    }

    public void getAllSubscribingUserLists(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAllUserLists(AsyncTwitter.this.twitter.getAllUserLists(screenName));
            }
        });
    }

    public void getAllSubscribingUserLists(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ALL_USER_LISTS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAllUserLists(AsyncTwitter.this.twitter.getAllUserLists(userId));
            }
        });
    }

    public void getUserListMembers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserListMembers(AsyncTwitter.this.twitter.getUserListMembers(listOwnerScreenName, listId, cursor));
            }
        });
    }

    public void addUserListMember(final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.addedUserListMember(AsyncTwitter.this.twitter.addUserListMember(listId, userId));
            }
        });
    }

    public void addUserListMembers(final int listId, final int[] userIds) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.addedUserListMembers(AsyncTwitter.this.twitter.addUserListMembers(listId, userIds));
            }
        });
    }

    public void addUserListMembers(final int listId, final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ADD_LIST_MEMBERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.addedUserListMembers(AsyncTwitter.this.twitter.addUserListMembers(listId, screenNames));
            }
        });
    }

    public void deleteUserListMember(final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DELETE_LIST_MEMBER, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.deletedUserListMember(AsyncTwitter.this.twitter.deleteUserListMember(listId, userId));
            }
        });
    }

    public void checkUserListMembership(final String listOwnerScreenName, final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CHECK_LIST_MEMBERSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.checkedUserListMembership(AsyncTwitter.this.twitter.checkUserListMembership(listOwnerScreenName, listId, userId));
            }
        });
    }

    public void getUserListSubscribers(final String listOwnerScreenName, final int listId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LIST_SUBSCRIBERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotUserListSubscribers(AsyncTwitter.this.twitter.getUserListSubscribers(listOwnerScreenName, listId, cursor));
            }
        });
    }

    public void subscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SUBSCRIBE_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.subscribedUserList(AsyncTwitter.this.twitter.subscribeUserList(listOwnerScreenName, listId));
            }
        });
    }

    public void unsubscribeUserList(final String listOwnerScreenName, final int listId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UNSUBSCRIBE_LIST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.unsubscribedUserList(AsyncTwitter.this.twitter.unsubscribeUserList(listOwnerScreenName, listId));
            }
        });
    }

    public void checkUserListSubscription(final String listOwnerScreenName, final int listId, final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CHECK_LIST_SUBSCRIPTION, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.checkedUserListSubscription(AsyncTwitter.this.twitter.checkUserListSubscription(listOwnerScreenName, listId, userId));
            }
        });
    }

    public void getDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.twitter.getDirectMessages());
            }
        });
    }

    public void getDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotDirectMessages(AsyncTwitter.this.twitter.getDirectMessages(paging));
            }
        });
    }

    public void getSentDirectMessages() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.twitter.getSentDirectMessages());
            }
        });
    }

    public void getSentDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotSentDirectMessages(AsyncTwitter.this.twitter.getSentDirectMessages(paging));
            }
        });
    }

    public void sendDirectMessage(final String screenName, final String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.twitter.sendDirectMessage(screenName, text));
            }
        });
    }

    public void sendDirectMessage(final int userId, final String text) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.sentDirectMessage(AsyncTwitter.this.twitter.sendDirectMessage(userId, text));
            }
        });
    }

    public void destroyDirectMessage(final int id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_DIRECT_MESSAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedDirectMessage(AsyncTwitter.this.twitter.destroyDirectMessage(id));
            }
        });
    }

    public void getDirectMessage(final int id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DIRECT_MESSAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotDirectMessage(AsyncTwitter.this.twitter.getDirectMessage(id));
            }
        });
    }

    public void createFriendship(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship(screenName));
            }
        });
    }

    public void createFriendship(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship(userId));
            }
        });
    }

    public void createFriendship(final String screenName, final boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship(screenName, follow));
            }
        });
    }

    public void createFriendship(final int userId, final boolean follow) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdFriendship(AsyncTwitter.this.twitter.createFriendship(userId, follow));
            }
        });
    }

    public void destroyFriendship(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedFriendship(AsyncTwitter.this.twitter.destroyFriendship(screenName));
            }
        });
    }

    public void destroyFriendship(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedFriendship(AsyncTwitter.this.twitter.destroyFriendship(userId));
            }
        });
    }

    public void existsFriendship(final String userA, final String userB) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotExistsFriendship(AsyncTwitter.this.twitter.existsFriendship(userA, userB));
            }
        });
    }

    public void showFriendship(final String sourceScreenName, final String targetScreenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotShowFriendship(AsyncTwitter.this.twitter.showFriendship(sourceScreenName, targetScreenName));
            }
        });
    }

    public void showFriendship(final int sourceId, final int targetId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotShowFriendship(AsyncTwitter.this.twitter.showFriendship(sourceId, targetId));
            }
        });
    }

    public void getIncomingFriendships(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.INCOMING_FRIENDSHIPS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotIncomingFriendships(AsyncTwitter.this.twitter.getIncomingFriendships(cursor));
            }
        });
    }

    public void getOutgoingFriendships(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.OUTGOING_FRIENDSHIPS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotOutgoingFriendships(AsyncTwitter.this.twitter.getOutgoingFriendships(cursor));
            }
        });
    }

    public void lookupFriendships(final String[] screenNames) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.lookedUpFriendships(AsyncTwitter.this.twitter.lookupFriendships(screenNames));
            }
        });
    }

    public void lookupFriendships(final int[] ids) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.lookedUpFriendships(AsyncTwitter.this.twitter.lookupFriendships(ids));
            }
        });
    }

    public void updateFriendship(final String screenName, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedFriendship(AsyncTwitter.this.twitter.updateFriendship(screenName, enableDeviceNotification, retweet));
            }
        });
    }

    public void updateFriendship(final int userId, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedFriendship(AsyncTwitter.this.twitter.updateFriendship(userId, enableDeviceNotification, retweet));
            }
        });
    }

    public void getFriendsIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs());
            }
        });
    }

    public void getFriendsIDs(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs(cursor));
            }
        });
    }

    public void getFriendsIDs(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs(userId));
            }
        });
    }

    public void getFriendsIDs(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs(userId, cursor));
            }
        });
    }

    public void getFriendsIDs(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs(screenName));
            }
        });
    }

    public void getFriendsIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFriendsIDs(AsyncTwitter.this.twitter.getFriendsIDs(screenName, cursor));
            }
        });
    }

    public void getFollowersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs());
            }
        });
    }

    public void getFollowersIDs(final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs(cursor));
            }
        });
    }

    public void getFollowersIDs(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs(userId));
            }
        });
    }

    public void getFollowersIDs(final int userId, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs(userId, cursor));
            }
        });
    }

    public void getFollowersIDs(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs(screenName));
            }
        });
    }

    public void getFollowersIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFollowersIDs(AsyncTwitter.this.twitter.getFollowersIDs(screenName, cursor));
            }
        });
    }

    public void verifyCredentials() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.VERIFY_CREDENTIALS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.verifiedCredentials(AsyncTwitter.this.twitter.verifyCredentials());
            }
        });
    }

    public void updateProfile(String name, String email, String url, String location, String description) {
        this.updateProfile(name, url, location, description);
    }

    public void updateProfile(final String name, final String url, final String location, final String description) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedProfile(AsyncTwitter.this.twitter.updateProfile(name, url, location, description));
            }
        });
    }

    public void getRateLimitStatus() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRateLimitStatus(AsyncTwitter.this.twitter.getRateLimitStatus());
            }
        });
    }

    public void updateDeliveryDevice(final Device device) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_DELIVERY_DEVICE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedDeliveryDevice(AsyncTwitter.this.twitter.updateDeliveryDevice(device));
            }
        });
    }

    public void updateProfileColors(final String profileBackgroundColor, final String profileTextColor, final String profileLinkColor, final String profileSidebarFillColor, final String profileSidebarBorderColor) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_COLORS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedProfileColors(AsyncTwitter.this.twitter.updateProfileColors(profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor));
            }
        });
    }

    public void updateProfileImage(final File image) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedProfileImage(AsyncTwitter.this.twitter.updateProfileImage(image));
            }
        });
    }

    public void updateProfileBackgroundImage(final File image, final boolean tile) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.updatedProfileBackgroundImage(AsyncTwitter.this.twitter.updateProfileBackgroundImage(image, tile));
            }
        });
    }

    public void getFavorites() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites());
            }
        });
    }

    public void getFavorites(final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites(page));
            }
        });
    }

    public void getFavorites(final String id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites(id));
            }
        });
    }

    public void getFavorites(final String id, final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.FAVORITES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotFavorites(AsyncTwitter.this.twitter.getFavorites(id, page));
            }
        });
    }

    public void createFavorite(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_FAVORITE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdFavorite(AsyncTwitter.this.twitter.createFavorite(id));
            }
        });
    }

    public void destroyFavorite(final long id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_FAVORITE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedFavorite(AsyncTwitter.this.twitter.destroyFavorite(id));
            }
        });
    }

    public void enableNotification(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.enabledNotification(AsyncTwitter.this.twitter.enableNotification(screenName));
            }
        });
    }

    public void enableNotification(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.ENABLE_NOTIFICATION, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.enabledNotification(AsyncTwitter.this.twitter.enableNotification(userId));
            }
        });
    }

    public void disableNotification(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.disabledNotification(AsyncTwitter.this.twitter.disableNotification(screenName));
            }
        });
    }

    public void disableNotification(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DISABLE_NOTIFICATION, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.disabledNotification(AsyncTwitter.this.twitter.disableNotification(userId));
            }
        });
    }

    public void createBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdBlock(AsyncTwitter.this.twitter.createBlock(screenName));
            }
        });
    }

    public void createBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdBlock(AsyncTwitter.this.twitter.createBlock(userId));
            }
        });
    }

    public void destroyBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedBlock(AsyncTwitter.this.twitter.destroyBlock(screenName));
            }
        });
    }

    public void destroyBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.destroyedBlock(AsyncTwitter.this.twitter.destroyBlock(userId));
            }
        });
    }

    public void existsBlock(final String screenName) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotExistsBlock(AsyncTwitter.this.twitter.existsBlock(screenName));
            }
        });
    }

    public void existsBlock(final int userId) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.EXISTS_BLOCK, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotExistsBlock(AsyncTwitter.this.twitter.existsBlock(userId));
            }
        });
    }

    public void getBlockingUsers() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.twitter.getBlockingUsers());
            }
        });
    }

    public void getBlockingUsers(final int page) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotBlockingUsers(AsyncTwitter.this.twitter.getBlockingUsers(page));
            }
        });
    }

    public void getBlockingUsersIDs() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.BLOCKING_USERS_IDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotBlockingUsersIDs(AsyncTwitter.this.twitter.getBlockingUsersIDs());
            }
        });
    }

    public void reportSpam(final int userId) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.reportedSpam(AsyncTwitter.this.twitter.reportSpam(userId));
            }
        });
    }

    public void reportSpam(final String screenName) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REPORT_SPAM, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.reportedSpam(AsyncTwitter.this.twitter.reportSpam(screenName));
            }
        });
    }

    public void getAvailableTrends() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAvailableTrends(AsyncTwitter.this.twitter.getAvailableTrends());
            }
        });
    }

    public void getAvailableTrends(final GeoLocation location) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotAvailableTrends(AsyncTwitter.this.twitter.getAvailableTrends(location));
            }
        });
    }

    public void getLocationTrends(final int woeid) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.LOCATION_TRENDS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotLocationTrends(AsyncTwitter.this.twitter.getLocationTrends(woeid));
            }
        });
    }

    public void searchPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SEARCH_PLACES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.searchedPlaces(AsyncTwitter.this.twitter.searchPlaces(query));
            }
        });
    }

    public void getSimilarPlaces(final GeoLocation location, final String name, final String containedWithin, final String streetAddress) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.SIMILAR_PLACES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotSimilarPlaces(AsyncTwitter.this.twitter.getSimilarPlaces(location, name, containedWithin, streetAddress));
            }
        });
    }

    public void getNearbyPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.NEAR_BY_PLACES, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotNearByPlaces(AsyncTwitter.this.twitter.getNearbyPlaces(query));
            }
        });
    }

    public void reverseGeoCode(final GeoQuery query) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.REVERSE_GEO_CODE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotReverseGeoCode(AsyncTwitter.this.twitter.reverseGeoCode(query));
            }
        });
    }

    public void getGeoDetails(final String id) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.GEO_DETAILS, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotGeoDetails(AsyncTwitter.this.twitter.getGeoDetails(id));
            }
        });
    }

    public void createPlace(final String name, final String containedWithin, final String token, final GeoLocation location, final String streetAddress) {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.CREATE_PLACE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.createdPlace(AsyncTwitter.this.twitter.createPlace(name, containedWithin, token, location, streetAddress));
            }
        });
    }

    public void getTermsOfService() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TERMS_OF_SERVICE, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotTermsOfService(AsyncTwitter.this.twitter.getTermsOfService());
            }
        });
    }

    public void getPrivacyPolicy() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.PRIVACY_POLICY, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.gotPrivacyPolicy(AsyncTwitter.this.twitter.getPrivacyPolicy());
            }
        });
    }

    public void getRelatedResults(final long statusId) throws TwitterException {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.RELATED_RESULTS, this.listener){

            void invoke(TwitterListener listener) throws TwitterException {
                listener.gotRelatedResults(AsyncTwitter.this.twitter.getRelatedResults(statusId));
            }
        });
    }

    public void test() {
        this.getDispatcher().invokeLater(new AsyncTask(TwitterMethod.TEST, this.listener){

            public void invoke(TwitterListener listener) throws TwitterException {
                listener.tested(AsyncTwitter.this.twitter.test());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        Class clazz = AsyncTwitter.class;
        synchronized (clazz) {
            if (this.shutdown) {
                throw new IllegalStateException("Already shut down");
            }
            if (dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            this.shutdown = true;
        }
    }

    private Dispatcher getDispatcher() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        if (null == dispatcher) {
            dispatcher = new DispatcherFactory(this.conf).getInstance();
        }
        return dispatcher;
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.twitter.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.twitter.getOAuthRequestToken(callbackUrl);
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        return this.twitter.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.twitter.setOAuthAccessToken(accessToken);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.twitter.getOAuthAccessToken(token, tokenSecret);
    }

    public AccessToken getOAuthAccessToken(String token, String tokenSecret, String pin) throws TwitterException {
        return this.twitter.getOAuthAccessToken(new RequestToken(token, tokenSecret), pin);
    }

    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.twitter.setOAuthAccessToken(token, tokenSecret);
    }

    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ Configuration getConfiguration() {
        return super.getConfiguration();
    }

    abstract class AsyncTask
    implements Runnable {
        TwitterListener listener;
        TwitterMethod method;

        AsyncTask(TwitterMethod method, TwitterListener listener) {
            this.method = method;
            this.listener = listener;
        }

        abstract void invoke(TwitterListener var1) throws TwitterException;

        public void run() {
            block2: {
                try {
                    this.invoke(this.listener);
                }
                catch (TwitterException te) {
                    if (null == this.listener) break block2;
                    this.listener.onException(te, this.method);
                }
            }
        }
    }
}

