/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.AbstractStreamImplementation;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class UserStreamImpl
extends AbstractStreamImplementation
implements UserStream {
    private StreamListener[] listeners;
    private String line;

    UserStreamImpl(InputStream stream) throws IOException {
        super(stream);
    }

    UserStreamImpl(HttpResponse response) throws IOException {
        super(response);
    }

    public void next(UserStreamListener listener) throws TwitterException {
        StreamListener[] list = new StreamListener[]{listener};
        this.listeners = list;
        this.handleNextElement();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listeners = listeners;
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        DataObjectFactoryUtil.clearThreadLocalMap();
        this.line = line;
        return line;
    }

    protected void onSender(JSONObject json) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onDirectMessage(new DirectMessageJSONImpl(json));
        }
    }

    protected void onText(JSONObject json) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onStatus(this.asStatus(json));
        }
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
        DirectMessage directMessage = this.asDirectMessage(json);
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onDirectMessage(directMessage);
        }
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException {
        logger.info("Geo-tagging deletion notice (not implemented yet): " + this.line);
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
        int[] friendIds = this.asFriendList(json);
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFriendList(friendIds);
        }
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUnfavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onRetweet(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFollow(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUnfollow(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUnfollow(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUserListSubscribed(JSONObject source, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListSubscribed(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListCreated(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListCreated(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListUpdated(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListUpdated(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListDestroyed(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onBlock(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUnblock(this.asUser(source), this.asUser(target));
        }
    }

    public void onException(Exception e) {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            listener.onException(e);
        }
    }
}

