/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import twitter4j.PagableResponseList;
import twitter4j.PagableResponseListImpl;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserJSONImpl
extends TwitterResponseImpl
implements User,
Serializable {
    private int id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private boolean isContributorsEnabled;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Status status;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private boolean profileBackgroundTiled;
    private String lang;
    private int statusesCount;
    private boolean isGeoEnabled;
    private boolean isVerified;
    private int listedCount;
    private boolean isFollowRequestSent;
    private static final long serialVersionUID = -6345893237975349030L;

    UserJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        DataObjectFactoryUtil.clearThreadLocalMap();
        JSONObject json = res.asJSONObject();
        this.init(json);
        DataObjectFactoryUtil.registerJSONObject(this, json);
    }

    UserJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.id = ParseUtil.getInt("id", json);
            this.name = ParseUtil.getRawString("name", json);
            this.screenName = ParseUtil.getRawString("screen_name", json);
            this.location = ParseUtil.getRawString("location", json);
            this.description = ParseUtil.getRawString("description", json);
            this.isContributorsEnabled = ParseUtil.getBoolean("contributors_enabled", json);
            this.profileImageUrl = ParseUtil.getRawString("profile_image_url", json);
            this.url = ParseUtil.getRawString("url", json);
            this.isProtected = ParseUtil.getBoolean("protected", json);
            this.isGeoEnabled = ParseUtil.getBoolean("geo_enabled", json);
            this.isVerified = ParseUtil.getBoolean("verified", json);
            this.followersCount = ParseUtil.getInt("followers_count", json);
            this.listedCount = ParseUtil.getInt("listed_count", json);
            this.profileBackgroundColor = ParseUtil.getRawString("profile_background_color", json);
            this.profileTextColor = ParseUtil.getRawString("profile_text_color", json);
            this.profileLinkColor = ParseUtil.getRawString("profile_link_color", json);
            this.profileSidebarFillColor = ParseUtil.getRawString("profile_sidebar_fill_color", json);
            this.profileSidebarBorderColor = ParseUtil.getRawString("profile_sidebar_border_color", json);
            this.friendsCount = ParseUtil.getInt("friends_count", json);
            this.createdAt = ParseUtil.getDate("created_at", json, "EEE MMM dd HH:mm:ss z yyyy");
            this.favouritesCount = ParseUtil.getInt("favourites_count", json);
            this.utcOffset = ParseUtil.getInt("utc_offset", json);
            this.timeZone = ParseUtil.getRawString("time_zone", json);
            this.profileBackgroundImageUrl = ParseUtil.getRawString("profile_background_image_url", json);
            this.profileBackgroundTiled = ParseUtil.getBoolean("profile_background_tile", json);
            this.lang = ParseUtil.getRawString("lang", json);
            this.statusesCount = ParseUtil.getInt("statuses_count", json);
            this.listedCount = ParseUtil.getInt("listed_count", json);
            this.isFollowRequestSent = ParseUtil.getBoolean("follow_request_sent", json);
            if (!json.isNull("status")) {
                JSONObject statusJSON = json.getJSONObject("status");
                this.status = new StatusJSONImpl(statusJSON);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(json.toString()).toString(), jsone);
        }
    }

    @Override
    public int compareTo(User that) {
        return this.id - that.getId();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isContributorsEnabled() {
        return this.isContributorsEnabled;
    }

    @Override
    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public int getFollowersCount() {
        return this.followersCount;
    }

    @Override
    public Date getStatusCreatedAt() {
        return this.status.getCreatedAt();
    }

    @Override
    public long getStatusId() {
        return this.status.getId();
    }

    @Override
    public String getStatusText() {
        return this.status.getText();
    }

    @Override
    public String getStatusSource() {
        return this.status.getSource();
    }

    @Override
    public boolean isStatusTruncated() {
        return this.status.isTruncated();
    }

    @Override
    public long getStatusInReplyToStatusId() {
        return this.status.getInReplyToStatusId();
    }

    @Override
    public int getStatusInReplyToUserId() {
        return this.status.getInReplyToUserId();
    }

    @Override
    public boolean isStatusFavorited() {
        return this.status.isFavorited();
    }

    @Override
    public String getStatusInReplyToScreenName() {
        return this.status.getInReplyToScreenName();
    }

    @Override
    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    @Override
    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    @Override
    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    @Override
    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    @Override
    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    @Override
    public int getFriendsCount() {
        return this.friendsCount;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    @Override
    public int getUtcOffset() {
        return this.utcOffset;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    @Override
    public boolean isProfileBackgroundTiled() {
        return this.profileBackgroundTiled;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public int getStatusesCount() {
        return this.statusesCount;
    }

    @Override
    public boolean isGeoEnabled() {
        return this.isGeoEnabled;
    }

    @Override
    public boolean isVerified() {
        return this.isVerified;
    }

    @Override
    public int getListedCount() {
        return this.listedCount;
    }

    @Override
    public boolean isFollowRequestSent() {
        return this.isFollowRequestSent;
    }

    static PagableResponseList<User> createPagableUserList(HttpResponse res) throws TwitterException {
        try {
            DataObjectFactoryUtil.clearThreadLocalMap();
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            PagableResponseListImpl users = new PagableResponseListImpl(size, json, res);
            for (int i = 0; i < size; ++i) {
                JSONObject userJson = list.getJSONObject(i);
                UserJSONImpl user = new UserJSONImpl(userJson);
                DataObjectFactoryUtil.registerJSONObject(user, userJson);
                users.add(user);
            }
            DataObjectFactoryUtil.registerJSONObject(users, json);
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    static ResponseList<User> createUserList(HttpResponse res) throws TwitterException {
        return UserJSONImpl.createUserList(res.asJSONArray(), res);
    }

    static ResponseList<User> createUserList(JSONArray list, HttpResponse res) throws TwitterException {
        try {
            DataObjectFactoryUtil.clearThreadLocalMap();
            int size = list.length();
            ResponseListImpl<User> users = new ResponseListImpl<User>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                UserJSONImpl user = new UserJSONImpl(json);
                users.add(user);
                DataObjectFactoryUtil.registerJSONObject(user, json);
            }
            DataObjectFactoryUtil.registerJSONObject(users, list);
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId() == this.id;
    }

    public String toString() {
        return new StringBuffer().append("UserJSONImpl{, id=").append(this.id).append(", name='").append(this.name).append('\'').append(", screenName='").append(this.screenName).append('\'').append(", location='").append(this.location).append('\'').append(", description='").append(this.description).append('\'').append(", profileImageUrl='").append(this.profileImageUrl).append('\'').append(", url='").append(this.url).append('\'').append(", isProtected=").append(this.isProtected).append(", followersCount=").append(this.followersCount).append(", status=").append(this.status).append(", profileBackgroundColor='").append(this.profileBackgroundColor).append('\'').append(", profileTextColor='").append(this.profileTextColor).append('\'').append(", profileLinkColor='").append(this.profileLinkColor).append('\'').append(", profileSidebarFillColor='").append(this.profileSidebarFillColor).append('\'').append(", profileSidebarBorderColor='").append(this.profileSidebarBorderColor).append('\'').append(", friendsCount=").append(this.friendsCount).append(", createdAt=").append(this.createdAt).append(", favouritesCount=").append(this.favouritesCount).append(", utcOffset=").append(this.utcOffset).append(", timeZone='").append(this.timeZone).append('\'').append(", profileBackgroundImageUrl='").append(this.profileBackgroundImageUrl).append('\'').append(", profileBackgroundTile='").append(this.profileBackgroundTiled).append('\'').append(", statusesCount=").append(this.statusesCount).append(", geoEnabled=").append(this.isGeoEnabled).append(", verified=").append(this.isVerified).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((User)x0);
    }
}

