/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.AbstractStreamImplementation;
import twitter4j.SiteStreamsListener;
import twitter4j.StreamImplementation;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class SiteStreamsImpl
extends AbstractStreamImplementation
implements StreamImplementation,
StreamListener {
    private int forUser;
    private final Dispatcher dispatcher;
    SiteStreamsListener listener;

    SiteStreamsImpl(Configuration conf, InputStream stream) throws IOException {
        super(stream);
        this.dispatcher = new DispatcherFactory(conf).getInstance();
    }

    SiteStreamsImpl(Configuration conf, HttpResponse response) throws IOException {
        super(response);
        this.dispatcher = new DispatcherFactory(conf).getInstance();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listener = (SiteStreamsListener)listeners[0];
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        if ("".equals(line) || null == line) {
            return line;
        }
        int userIdEnd = line.indexOf(44, 12);
        if (line.charAt(12) == '\"') {
            this.forUser = Integer.parseInt(line.substring(13, userIdEnd - 1));
            return line.substring(userIdEnd + 11, line.length() - 1);
        }
        this.forUser = Integer.parseInt(line.substring(12, userIdEnd));
        return line.substring(userIdEnd + 11, line.length() - 1);
    }

    protected void onText(final JSONObject json) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onStatus(this.FOR_USER, SiteStreamsImpl.this.asStatus(json));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onDirectMessage(final JSONObject json) throws TwitterException, JSONException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onDirectMessage(this.FOR_USER, SiteStreamsImpl.this.asDirectMessage(json));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onFriends(final JSONObject json) throws TwitterException, JSONException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onFriendList(this.FOR_USER, SiteStreamsImpl.this.asFriendList(json));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onFavorite(final JSONObject source, final JSONObject target, final JSONObject targetObject) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onFavorite(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(target), SiteStreamsImpl.this.asStatus(targetObject));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUnfavorite(final JSONObject source, final JSONObject target, final JSONObject targetObject) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUnfavorite(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(target), SiteStreamsImpl.this.asStatus(targetObject));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onFollow(final JSONObject source, final JSONObject target) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onFollow(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(target));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUserListSubscribed(final JSONObject source, final JSONObject owner, final JSONObject userList) throws TwitterException, JSONException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUserListSubscribed(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(owner), SiteStreamsImpl.this.asUserList(userList));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUserListCreated(final JSONObject source, final JSONObject userList) throws TwitterException, JSONException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUserListCreated(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUserList(userList));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUserListUpdated(final JSONObject source, final JSONObject userList) throws TwitterException, JSONException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUserListUpdated(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUserList(userList));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUserListDestroyed(final JSONObject source, final JSONObject userList) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUserListDestroyed(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUserList(userList));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onBlock(final JSONObject source, final JSONObject target) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onBlock(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(target));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    protected void onUnblock(final JSONObject source, final JSONObject target) throws TwitterException {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                try {
                    SiteStreamsImpl.this.listener.onUnblock(this.FOR_USER, SiteStreamsImpl.this.asUser(source), SiteStreamsImpl.this.asUser(target));
                }
                catch (TwitterException te) {
                    SiteStreamsImpl.this.listener.onException(te);
                }
            }
        });
    }

    public void onException(final Exception ex) {
        this.dispatcher.invokeLater(new SiteStreamEvent(this.forUser){

            public void run() {
                SiteStreamsImpl.this.listener.onException(ex);
            }
        });
    }

    abstract class SiteStreamEvent
    implements Runnable {
        final int FOR_USER;

        SiteStreamEvent(int forUser) {
            this.FOR_USER = forUser;
        }
    }
}

