/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.Category;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CategoryJSONImpl
implements Category,
Serializable {
    private String name;
    private String slug;
    private static final long serialVersionUID = -6703617743623288566L;

    CategoryJSONImpl(String name, String slug) {
        this.name = name;
        this.slug = slug;
    }

    CategoryJSONImpl(JSONObject json) throws JSONException {
        this.init(json);
    }

    void init(JSONObject json) throws JSONException {
        this.name = json.getString("name");
        this.slug = json.getString("slug");
    }

    public static ResponseList<Category> createCategoriesList(HttpResponse res) throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(res.asJSONArray(), res);
    }

    public static ResponseList<Category> createCategoriesList(JSONArray array, HttpResponse res) throws TwitterException {
        try {
            DataObjectFactoryUtil.clearThreadLocalMap();
            ResponseListImpl<Category> categories = new ResponseListImpl<Category>(array.length(), res);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject json = array.getJSONObject(i);
                CategoryJSONImpl category = new CategoryJSONImpl(json);
                categories.add(category);
                DataObjectFactoryUtil.registerJSONObject(category, json);
            }
            DataObjectFactoryUtil.registerJSONObject(categories, array);
            return categories;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryJSONImpl that = (CategoryJSONImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.slug != null ? !this.slug.equals(that.slug) : that.slug != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.slug != null ? this.slug.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("CategoryJSONImpl{name='").append(this.name).append('\'').append(", slug='").append(this.slug).append('\'').append('}').toString();
    }
}

