/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.Place;
import twitter4j.RateLimitStatus;
import twitter4j.Relationship;
import twitter4j.SavedSearch;
import twitter4j.Status;
import twitter4j.Trend;
import twitter4j.Trends;
import twitter4j.Tweet;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataObjectFactory {
    private static final Constructor<Status> statusConstructor;
    private static final Constructor<User> userConstructor;
    private static final Constructor<Tweet> tweetConstructor;
    private static final Constructor<Relationship> relationshipConstructor;
    private static final Constructor<Place> placeConstructor;
    private static final Constructor<SavedSearch> savedSearchConstructor;
    private static final Constructor<Trend> trendConstructor;
    private static final Constructor<Trends> trendsConstructor;
    private static final Constructor<IDs> IDsConstructor;
    private static final Constructor<RateLimitStatus> rateLimitStatusConstructor;
    private static final Constructor<Category> categoryConstructor;
    private static final Constructor<DirectMessage> directMessageConstructor;
    private static final Constructor<Location> locationConstructor;
    private static final Constructor<UserList> userListConstructor;
    private static ThreadLocal<Map> rawJsonMap;
    static /* synthetic */ Class class$twitter4j$internal$org$json$JSONObject;
    static /* synthetic */ Class class$java$lang$String;

    private DataObjectFactory() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String getRawJSON(Object obj) {
        Object json = rawJsonMap.get().get(obj);
        if (json instanceof String) {
            return (String)json;
        }
        if (json != null) {
            return json.toString();
        }
        return null;
    }

    public static Status createStatus(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return statusConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static User createUser(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return userConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Tweet createTweet(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return tweetConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Relationship createRelationship(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return relationshipConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Place createPlace(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return placeConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static SavedSearch createSavedSearch(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return savedSearchConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Trend createTrend(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return trendConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Trends createTrends(String rawJSON) throws TwitterException {
        try {
            return trendsConstructor.newInstance(rawJSON);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static IDs createIDs(String rawJSON) throws TwitterException {
        try {
            return IDsConstructor.newInstance(rawJSON);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RateLimitStatus createRateLimitStatus(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return rateLimitStatusConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Category createCategory(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return categoryConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static DirectMessage createDirectMessage(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return directMessageConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static Location createLocation(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return locationConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public static UserList createUserList(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return userListConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    static void clearThreadLocalMap() {
        rawJsonMap.get().clear();
    }

    static <T> T registerJSONObject(T key, Object json) {
        rawJsonMap.get().put(key, json);
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        try {
            statusConstructor = Class.forName("twitter4j.StatusJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            statusConstructor.setAccessible(true);
            userConstructor = Class.forName("twitter4j.UserJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            userConstructor.setAccessible(true);
            tweetConstructor = Class.forName("twitter4j.TweetJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            tweetConstructor.setAccessible(true);
            relationshipConstructor = Class.forName("twitter4j.RelationshipJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            relationshipConstructor.setAccessible(true);
            placeConstructor = Class.forName("twitter4j.PlaceJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            placeConstructor.setAccessible(true);
            savedSearchConstructor = Class.forName("twitter4j.SavedSearchJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            savedSearchConstructor.setAccessible(true);
            trendConstructor = Class.forName("twitter4j.TrendJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            trendConstructor.setAccessible(true);
            trendsConstructor = Class.forName("twitter4j.TrendsJSONImpl").getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = DataObjectFactory.class$("java.lang.String")) : class$java$lang$String);
            trendsConstructor.setAccessible(true);
            IDsConstructor = Class.forName("twitter4j.IDsJSONImpl").getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = DataObjectFactory.class$("java.lang.String")) : class$java$lang$String);
            IDsConstructor.setAccessible(true);
            rateLimitStatusConstructor = Class.forName("twitter4j.RateLimitStatusJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            rateLimitStatusConstructor.setAccessible(true);
            categoryConstructor = Class.forName("twitter4j.CategoryJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            categoryConstructor.setAccessible(true);
            directMessageConstructor = Class.forName("twitter4j.DirectMessageJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            directMessageConstructor.setAccessible(true);
            locationConstructor = Class.forName("twitter4j.LocationJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            locationConstructor.setAccessible(true);
            userListConstructor = Class.forName("twitter4j.UserListJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            userListConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        rawJsonMap = new ThreadLocal<Map>(){

            @Override
            protected Map initialValue() {
                return new HashMap();
            }

            @Override
            protected /* synthetic */ Object initialValue() {
                return this.initialValue();
            }
        };
    }
}

