/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBase;
import twitter4j.internal.util.StringUtil;

public final class PropertyConfiguration
extends ConfigurationBase
implements Serializable {
    public static final String DEBUG = "debug";
    public static final String SOURCE = "source";
    public static final String HTTP_USER_AGENT = "http.userAgent";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String HTTP_USE_SSL = "http.useSSL";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    public static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    public static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    public static final String HTTP_STREAMING_READ_TIMEOUT = "http.streamingReadTimeout";
    public static final String HTTP_RETRY_COUNT = "http.retryCount";
    public static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    public static final String HTTP_MAX_TOTAL_CONNECTIONS = "http.maxTotalConnections";
    public static final String HTTP_DEFAULT_MAX_PER_ROUTE = "http.defaultMaxPerRoute";
    public static final String OAUTH_CONSUMER_KEY = "oauth.consumerKey";
    public static final String OAUTH_CONSUMER_SECRET = "oauth.consumerSecret";
    public static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    public static final String OAUTH_ACCESS_TOKEN_SECRET = "oauth.accessTokenSecret";
    public static final String OAUTH_REQUEST_TOKEN_URL = "oauth.requestTokenURL";
    public static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    public static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    public static final String OAUTH_AUTHENTICATION_URL = "oauth.authenticationURL";
    public static final String REST_BASE_URL = "restBaseURL";
    public static final String SEARCH_BASE_URL = "searchBaseURL";
    public static final String STREAM_BASE_URL = "streamBaseURL";
    public static final String ASYNC_NUM_THREADS = "async.numThreads";
    public static final String ASYNC_DISPATCHER_IMPL = "async.dispatherImpl";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String CLIENT_URL = "clientURL";
    private static final long serialVersionUID = 6458764415636588373L;

    public PropertyConfiguration(InputStream is) {
        Properties props = new Properties();
        this.loadProperties(props, is);
        this.setFieldsWithTreePath(props, "/");
    }

    public PropertyConfiguration(Properties props) {
        this.setFieldsWithTreePath(props, "/");
    }

    PropertyConfiguration(String treePath) {
        Properties props = null;
        try {
            props = (Properties)System.getProperties().clone();
            this.normalize(props);
        }
        catch (AccessControlException ace) {
            props = new Properties();
        }
        String TWITTER4J_PROPERTIES = "twitter4j.properties";
        this.loadProperties(props, "." + File.separatorChar + "twitter4j.properties");
        this.loadProperties(props, Configuration.class.getResourceAsStream("/twitter4j.properties"));
        this.loadProperties(props, Configuration.class.getResourceAsStream("/WEB-INF/twitter4j.properties"));
        this.setFieldsWithTreePath(props, treePath);
    }

    PropertyConfiguration() {
        this("/");
    }

    private boolean notNull(Properties props, String prefix, String name) {
        return null != props.getProperty(prefix + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties(Properties props, String path) {
        FileInputStream fis = null;
        try {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                fis = new FileInputStream(file);
                props.load(new FileInputStream(file));
                this.normalize(props);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ignore) {
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException ignore) {}
        }
        return false;
    }

    private boolean loadProperties(Properties props, InputStream is) {
        try {
            props.load(is);
            this.normalize(props);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void normalize(Properties props) {
        Set<Object> keys = props.keySet();
        ArrayList<String> toBeNormalized = new ArrayList<String>(10);
        Iterator<Object> i$ = keys.iterator();
        while (i$.hasNext()) {
            Object key = i$.next();
            String keyStr = (String)key;
            if (-1 == keyStr.indexOf("twitter4j.")) continue;
            toBeNormalized.add(keyStr);
        }
        i$ = toBeNormalized.iterator();
        while (i$.hasNext()) {
            String keyStr = (String)i$.next();
            String property = props.getProperty(keyStr);
            int index = keyStr.indexOf("twitter4j.");
            String newKey = keyStr.substring(0, index) + keyStr.substring(index + 10);
            props.setProperty(newKey, property);
        }
    }

    private void setFieldsWithTreePath(Properties props, String treePath) {
        this.setFieldsWithPrefix(props, "");
        String[] splitArray = StringUtil.split(treePath, "/");
        String prefix = null;
        String[] arr$ = splitArray;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String split = arr$[i$];
            if ("".equals(split)) continue;
            prefix = null == prefix ? split + "." : prefix + split + ".";
            this.setFieldsWithPrefix(props, prefix);
        }
    }

    private void setFieldsWithPrefix(Properties props, String prefix) {
        if (this.notNull(props, prefix, DEBUG)) {
            this.setDebug(this.getBoolean(props, prefix, DEBUG));
        }
        if (this.notNull(props, prefix, SOURCE)) {
            this.setSource(this.getString(props, prefix, SOURCE));
        }
        if (this.notNull(props, prefix, USER)) {
            this.setUser(this.getString(props, prefix, USER));
        }
        if (this.notNull(props, prefix, PASSWORD)) {
            this.setPassword(this.getString(props, prefix, PASSWORD));
        }
        if (this.notNull(props, prefix, HTTP_USE_SSL)) {
            this.setUseSSL(this.getBoolean(props, prefix, HTTP_USE_SSL));
        } else if (this.notNull(props, prefix, USER) && this.notNull(props, prefix, PASSWORD)) {
            this.setUseSSL(true);
        }
        if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        } else if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_USER)) {
            this.setHttpProxyUser(this.getString(props, prefix, HTTP_PROXY_USER));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_PASSWORD)) {
            this.setHttpProxyPassword(this.getString(props, prefix, HTTP_PROXY_PASSWORD));
        }
        if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        } else if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        }
        if (this.notNull(props, prefix, HTTP_CONNECTION_TIMEOUT)) {
            this.setHttpConnectionTimeout(this.getIntProperty(props, prefix, HTTP_CONNECTION_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_READ_TIMEOUT)) {
            this.setHttpReadTimeout(this.getIntProperty(props, prefix, HTTP_READ_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_STREAMING_READ_TIMEOUT)) {
            this.setHttpStreamingReadTimeout(this.getIntProperty(props, prefix, HTTP_STREAMING_READ_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_COUNT)) {
            this.setHttpRetryCount(this.getIntProperty(props, prefix, HTTP_RETRY_COUNT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_INTERVAL_SECS)) {
            this.setHttpRetryIntervalSeconds(this.getIntProperty(props, prefix, HTTP_RETRY_INTERVAL_SECS));
        }
        if (this.notNull(props, prefix, HTTP_MAX_TOTAL_CONNECTIONS)) {
            this.setHttpMaxTotalConnections(this.getIntProperty(props, prefix, HTTP_MAX_TOTAL_CONNECTIONS));
        }
        if (this.notNull(props, prefix, HTTP_DEFAULT_MAX_PER_ROUTE)) {
            this.setHttpDefaultMaxPerRoute(this.getIntProperty(props, prefix, HTTP_DEFAULT_MAX_PER_ROUTE));
        }
        if (this.notNull(props, prefix, OAUTH_CONSUMER_KEY)) {
            this.setOAuthConsumerKey(this.getString(props, prefix, OAUTH_CONSUMER_KEY));
        }
        if (this.notNull(props, prefix, OAUTH_CONSUMER_SECRET)) {
            this.setOAuthConsumerSecret(this.getString(props, prefix, OAUTH_CONSUMER_SECRET));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN)) {
            this.setOAuthAccessToken(this.getString(props, prefix, OAUTH_ACCESS_TOKEN));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_SECRET)) {
            this.setOAuthAccessTokenSecret(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_SECRET));
        }
        if (this.notNull(props, prefix, ASYNC_NUM_THREADS)) {
            this.setAsyncNumThreads(this.getIntProperty(props, prefix, ASYNC_NUM_THREADS));
        }
        if (this.notNull(props, prefix, ASYNC_DISPATCHER_IMPL)) {
            this.setAsyncNumThreads(this.getIntProperty(props, prefix, ASYNC_DISPATCHER_IMPL));
        }
        if (this.notNull(props, prefix, CLIENT_VERSION)) {
            this.setClientVersion(this.getString(props, prefix, CLIENT_VERSION));
        }
        if (this.notNull(props, prefix, CLIENT_URL)) {
            this.setClientURL(this.getString(props, prefix, CLIENT_URL));
        }
        if (this.notNull(props, prefix, HTTP_USER_AGENT)) {
            this.setUserAgent(this.getString(props, prefix, HTTP_USER_AGENT));
        }
        if (this.notNull(props, prefix, OAUTH_REQUEST_TOKEN_URL)) {
            this.setOAuthRequestTokenURL(this.getString(props, prefix, OAUTH_REQUEST_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH_AUTHORIZATION_URL)) {
            this.setOAuthAuthorizationURL(this.getString(props, prefix, OAUTH_AUTHORIZATION_URL));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_URL)) {
            this.setOAuthAccessTokenURL(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH_AUTHENTICATION_URL)) {
            this.setOAuthAuthenticationURL(this.getString(props, prefix, OAUTH_AUTHENTICATION_URL));
        }
        if (this.notNull(props, prefix, REST_BASE_URL)) {
            this.setRestBaseURL(this.getString(props, prefix, REST_BASE_URL));
        }
        if (this.notNull(props, prefix, SEARCH_BASE_URL)) {
            this.setSearchBaseURL(this.getString(props, prefix, SEARCH_BASE_URL));
        }
        if (this.notNull(props, prefix, STREAM_BASE_URL)) {
            this.setStreamBaseURL(this.getString(props, prefix, STREAM_BASE_URL));
        }
    }

    protected boolean getBoolean(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        return Boolean.valueOf(value);
    }

    protected int getIntProperty(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected String getString(Properties props, String prefix, String name) {
        return props.getProperty(prefix + name);
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ String getDispatcherImpl() {
        return super.getDispatcherImpl();
    }

    public /* synthetic */ String getOAuthAuthenticationURL() {
        return super.getOAuthAuthenticationURL();
    }

    public /* synthetic */ String getOAuthAccessTokenURL() {
        return super.getOAuthAccessTokenURL();
    }

    public /* synthetic */ String getOAuthAuthorizationURL() {
        return super.getOAuthAuthorizationURL();
    }

    public /* synthetic */ String getOAuthRequestTokenURL() {
        return super.getOAuthRequestTokenURL();
    }

    public /* synthetic */ String getUserStreamBaseURL() {
        return super.getUserStreamBaseURL();
    }

    public /* synthetic */ String getStreamBaseURL() {
        return super.getStreamBaseURL();
    }

    public /* synthetic */ String getSearchBaseURL() {
        return super.getSearchBaseURL();
    }

    public /* synthetic */ String getRestBaseURL() {
        return super.getRestBaseURL();
    }

    public /* synthetic */ String getOAuthAccessTokenSecret() {
        return super.getOAuthAccessTokenSecret();
    }

    public /* synthetic */ String getOAuthAccessToken() {
        return super.getOAuthAccessToken();
    }

    public /* synthetic */ int getHttpStreamingReadTimeout() {
        return super.getHttpStreamingReadTimeout();
    }

    public /* synthetic */ Map getRequestHeaders() {
        return super.getRequestHeaders();
    }
}

