/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import twitter4j.Annotation;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations
implements Serializable {
    private static final long serialVersionUID = 7928827620306593741L;
    public static final int lengthLimit = 512;
    private List<Annotation> annotations = null;

    public Annotations() {
        this.setAnnotations(null);
    }

    public Annotations(List<Annotation> annotations) {
        this.setAnnotations(annotations);
    }

    Annotations(JSONArray jsonArray) {
        this.setAnnotations(null);
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.addAnnotation(new Annotation(jsonArray.getJSONObject(i)));
            }
        }
        catch (JSONException jsone) {
            this.annotations.clear();
        }
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations == null ? new ArrayList() : annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public Annotations annotation(Annotation annotation) {
        this.addAnnotation(annotation);
        return this;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public Integer size() {
        return new Integer(this.annotations.size());
    }

    public static boolean isExceedingLengthLimit(Annotations annotations) {
        return annotations.asParameterValue().length() > 512;
    }

    public boolean isExceedingLengthLimit() {
        return Annotations.isExceedingLengthLimit(this);
    }

    String asParameterValue() {
        JSONArray jsonArray = new JSONArray();
        for (Annotation annotation : this.annotations) {
            jsonArray.put(annotation.asJSONObject());
        }
        return jsonArray.toString();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Annotations && ((Object)((Annotations)obj).getSortedAnnotations()).equals(this.getSortedAnnotations());
    }

    public int hashCode() {
        return ((Object)this.getSortedAnnotations()).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Annotations{");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.annotations.get(i).toString());
        }
        sb.append('}');
        return sb.toString();
    }

    private List<Annotation> getSortedAnnotations() {
        ArrayList<Annotation> sortedAnnotations = new ArrayList<Annotation>(this.size());
        sortedAnnotations.addAll(this.annotations);
        Collections.sort(sortedAnnotations);
        return sortedAnnotations;
    }
}

