/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Date;
import twitter4j.Annotations;
import twitter4j.GeoLocation;
import twitter4j.ParseUtil;
import twitter4j.Tweet;
import twitter4j.TwitterException;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

final class TweetJSONImpl
implements Tweet,
Serializable {
    private String text;
    private int toUserId = -1;
    private String toUser = null;
    private String fromUser;
    private long id;
    private int fromUserId;
    private String isoLanguageCode = null;
    private String source;
    private String profileImageUrl;
    private Date createdAt;
    private String location;
    private GeoLocation geoLocation = null;
    private Annotations annotations = null;
    private static final long serialVersionUID = 4299736733993211587L;

    TweetJSONImpl(JSONObject tweet) throws TwitterException {
        this.text = ParseUtil.getUnescapedString("text", tweet);
        this.toUserId = ParseUtil.getInt("to_user_id", tweet);
        this.toUser = ParseUtil.getRawString("to_user", tweet);
        this.fromUser = ParseUtil.getRawString("from_user", tweet);
        this.id = ParseUtil.getLong("id", tweet);
        this.fromUserId = ParseUtil.getInt("from_user_id", tweet);
        this.isoLanguageCode = ParseUtil.getRawString("iso_language_code", tweet);
        this.source = ParseUtil.getUnescapedString("source", tweet);
        this.profileImageUrl = ParseUtil.getUnescapedString("profile_image_url", tweet);
        this.createdAt = ParseUtil.getDate("created_at", tweet, "EEE, dd MMM yyyy HH:mm:ss z");
        this.location = ParseUtil.getRawString("location", tweet);
        this.geoLocation = GeoLocation.getInstance(tweet);
        if (!tweet.isNull("annotations")) {
            try {
                JSONArray annotationsArray = tweet.getJSONArray("annotations");
                this.annotations = new Annotations(annotationsArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public int compareTo(Tweet that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    public String getText() {
        return this.text;
    }

    public int getToUserId() {
        return this.toUserId;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public long getId() {
        return this.id;
    }

    public int getFromUserId() {
        return this.fromUserId;
    }

    public String getIsoLanguageCode() {
        return this.isoLanguageCode;
    }

    public String getSource() {
        return this.source;
    }

    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tweet)) {
            return false;
        }
        Tweet tweet = (Tweet)o;
        return this.id == tweet.getId();
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.toUserId;
        result = 31 * result + (this.toUser != null ? this.toUser.hashCode() : 0);
        result = 31 * result + this.fromUser.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.fromUserId;
        result = 31 * result + (this.isoLanguageCode != null ? this.isoLanguageCode.hashCode() : 0);
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.profileImageUrl.hashCode();
        result = 31 * result + this.createdAt.hashCode();
        result = 31 * result + (this.geoLocation != null ? this.geoLocation.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TweetJSONImpl{text='" + this.text + '\'' + ", toUserId=" + this.toUserId + ", toUser='" + this.toUser + '\'' + ", fromUser='" + this.fromUser + '\'' + ", id=" + this.id + ", fromUserId=" + this.fromUserId + ", isoLanguageCode='" + this.isoLanguageCode + '\'' + ", source='" + this.source + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", createdAt=" + this.createdAt + ", geoLocation=" + this.geoLocation + ", annotations=" + this.annotations + '}';
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Tweet)x0);
    }
}

