/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.ParseUtil;
import twitter4j.StatusDeletionNotice;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class StatusDeletionNoticeImpl
implements StatusDeletionNotice,
Serializable {
    private long statusId;
    private int userId;
    private static final long serialVersionUID = 1723338404242596062L;

    StatusDeletionNoticeImpl(JSONObject json) throws JSONException {
        JSONObject deletionNotice = json.getJSONObject("delete");
        JSONObject status = deletionNotice.has("status") ? deletionNotice.getJSONObject("status") : deletionNotice.getJSONObject("direct_message");
        this.statusId = ParseUtil.getLong("id", status);
        this.userId = ParseUtil.getInt("user_id", status);
    }

    public long getStatusId() {
        return this.statusId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int compareTo(StatusDeletionNotice that) {
        long delta = this.statusId - that.getStatusId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatusDeletionNotice)) {
            return false;
        }
        StatusDeletionNotice that = (StatusDeletionNotice)o;
        if (this.statusId != that.getStatusId()) {
            return false;
        }
        return this.userId == that.getUserId();
    }

    public int hashCode() {
        int result = (int)(this.statusId ^ this.statusId >>> 32);
        result = 31 * result + this.userId;
        return result;
    }

    public String toString() {
        return "StatusDeletionNoticeImpl{statusId=" + this.statusId + ", userId=" + this.userId + '}';
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((StatusDeletionNotice)x0);
    }
}

