/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.TwitterException;
import twitter4j.UserMentionEntity;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

class UserMentionEntityJSONImpl
implements UserMentionEntity {
    private static final long serialVersionUID = 1255718748798369111L;
    private int start = -1;
    private int end = -1;
    private String name;
    private String screenName;
    private int id;

    UserMentionEntityJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.start = indicesArray.getInt(0);
            this.end = indicesArray.getInt(1);
            if (!json.isNull("name")) {
                this.name = json.getString("name");
            }
            if (!json.isNull("screen_name")) {
                this.screenName = json.getString("screen_name");
            }
            this.id = ParseUtil.getInt("id", json);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public int getId() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMentionEntityJSONImpl that = (UserMentionEntityJSONImpl)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null);
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return "UserMentionEntityJSONImpl{start=" + this.start + ", end=" + this.end + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", id=" + this.id + '}';
    }
}

