/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.AsyncTwitter;
import twitter4j.TwitterListener;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.OAuthAuthorization;

public final class AsyncTwitterFactory
implements Serializable {
    private final TwitterListener listener;
    private final Configuration conf;
    private static final long serialVersionUID = -2565686715640816219L;

    public AsyncTwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public AsyncTwitterFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
        this.listener = null;
    }

    public AsyncTwitterFactory(Configuration conf, TwitterListener listener) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
        this.listener = listener;
    }

    public AsyncTwitterFactory(TwitterListener listener) {
        this.conf = ConfigurationContext.getInstance();
        this.listener = listener;
    }

    public AsyncTwitterFactory(String configTreePath) {
        this.conf = ConfigurationContext.getInstance(configTreePath);
        this.listener = null;
    }

    public AsyncTwitterFactory(String configTreePath, TwitterListener listener) {
        this.conf = ConfigurationContext.getInstance(configTreePath);
        this.listener = listener;
    }

    public AsyncTwitter getInstance() {
        return this.getInstance(this.conf);
    }

    public AsyncTwitter getInstance(String screenName, String password) {
        return this.getInstance(this.conf, new BasicAuthorization(screenName, password));
    }

    public AsyncTwitter getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret, accessToken);
        return this.getInstance(this.conf, oauth);
    }

    public AsyncTwitter getInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }

    public AsyncTwitter getOAuthAuthorizedInstance(String consumerKey, String consumerSecret) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        return this.getInstance(this.conf, oauth);
    }

    public AsyncTwitter getOAuthAuthorizedInstance(String consumerKey, String consumerSecret, AccessToken accessToken) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(this.conf, oauth);
    }

    public AsyncTwitter getOAuthAuthorizedInstance(AccessToken accessToken) {
        return this.getInstance(accessToken);
    }

    private AsyncTwitter getInstance(Configuration conf, Authorization auth) {
        AsyncTwitter twitter = new AsyncTwitter(conf, auth);
        if (null != this.listener) {
            twitter.addListener(this.listener);
        }
        return twitter;
    }

    private AsyncTwitter getInstance(Configuration conf) {
        AsyncTwitter asyncTwitter = new AsyncTwitter(conf, AuthorizationFactory.getInstance(conf));
        if (null != this.listener) {
            asyncTwitter.addListener(this.listener);
        }
        return asyncTwitter;
    }
}

