/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import twitter4j.Version;
import twitter4j.conf.Configuration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationBase
implements Configuration,
Serializable {
    private boolean debug;
    private String source;
    private String userAgent;
    private String user;
    private String password;
    private boolean useSSL;
    private boolean prettyDebug;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private int maxTotalConnections;
    private int defaultMaxPerRoute;
    private String oAuthConsumerKey;
    private String oAuthConsumerSecret;
    private String oAuthAccessToken;
    private String oAuthAccessTokenSecret;
    private String oAuthRequestTokenURL;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAuthenticationURL;
    private String restBaseURL;
    private String searchBaseURL;
    private String streamBaseURL;
    private String userStreamBaseURL;
    private String siteStreamBaseURL;
    private String dispatcherImpl;
    private int asyncNumThreads;
    private boolean includeRTsEnabled;
    private boolean includeEntitiesEnabled;
    private boolean userStreamRepliesAllEnabled;
    private String mediaProvider;
    private String mediaProviderAPIKey;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "twitter4j.dalvik";
    private static final String DEFAULT_OAUTH_REQUEST_TOKEN_URL = "http://api.twitter.com/oauth/request_token";
    private static final String DEFAULT_OAUTH_AUTHORIZATION_URL = "http://api.twitter.com/oauth/authorize";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "http://api.twitter.com/oauth/access_token";
    private static final String DEFAULT_OAUTH_AUTHENTICATION_URL = "http://api.twitter.com/oauth/authenticate";
    private static final String DEFAULT_REST_BASE_URL = "http://api.twitter.com/1/";
    private static final String DEFAULT_SEARCH_BASE_URL = "http://search.twitter.com/";
    private static final String DEFAULT_STREAM_BASE_URL = "http://stream.twitter.com/1/";
    private static final String DEFAULT_USER_STREAM_BASE_URL = "https://userstream.twitter.com/2/";
    private static final String DEFAULT_SITE_STREAM_BASE_URL = "https://betastream.twitter.com/2b/";
    private boolean IS_DALVIK;
    private static final long serialVersionUID = -6610497517837844232L;
    static String dalvikDetected;
    Map<String, String> requestHeaders;

    protected ConfigurationBase() {
        String isDalvik;
        this.setDebug(false);
        this.setSource("Twitter4J");
        this.setUser(null);
        this.setPassword(null);
        this.setUseSSL(false);
        this.setPrettyDebugEnabled(false);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(300000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setHttpMaxTotalConnections(20);
        this.setHttpDefaultMaxPerRoute(2);
        this.setOAuthConsumerKey(null);
        this.setOAuthConsumerSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthAccessTokenSecret(null);
        this.setAsyncNumThreads(1);
        this.setClientVersion(Version.getVersion());
        this.setClientURL(new StringBuffer().append("http://twitter4j.org/en/twitter4j-").append(Version.getVersion()).append(".xml").toString());
        this.setUserAgent(new StringBuffer().append("twitter4j http://twitter4j.org/ /").append(Version.getVersion()).toString());
        this.setIncludeRTsEnbled(true);
        this.setIncludeEntitiesEnbled(false);
        this.setOAuthRequestTokenURL(DEFAULT_OAUTH_REQUEST_TOKEN_URL);
        this.setOAuthAuthorizationURL(DEFAULT_OAUTH_AUTHORIZATION_URL);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setOAuthAuthenticationURL(DEFAULT_OAUTH_AUTHENTICATION_URL);
        this.setRestBaseURL(DEFAULT_REST_BASE_URL);
        this.setSearchBaseURL(DEFAULT_SEARCH_BASE_URL);
        this.setStreamBaseURL(DEFAULT_STREAM_BASE_URL);
        this.setUserStreamBaseURL(DEFAULT_USER_STREAM_BASE_URL);
        this.setSiteStreamBaseURL(DEFAULT_SITE_STREAM_BASE_URL);
        this.setDispatcherImpl("twitter4j.internal.async.DispatcherImpl");
        this.setIncludeRTsEnbled(true);
        this.setUserStreamRepliesAllEnabled(false);
        try {
            isDalvik = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException ignore) {
            isDalvik = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(isDalvik);
        this.setMediaProvider("YFROG");
        this.setMediaProviderAPIKey(null);
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    protected final void setSource(String source) {
        this.source = source;
        this.initRequestHeaders();
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String user) {
        this.user = user;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    protected final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPrettyDebugEnabled() {
        return this.prettyDebug;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.fixRestBaseURL();
    }

    protected final void setPrettyDebugEnabled(boolean prettyDebug) {
        this.prettyDebug = prettyDebug;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", this.getClientVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", this.getClientURL());
        this.requestHeaders.put("X-Twitter-Client", this.getSource());
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        this.requestHeaders.put("Accept-Encoding", "gzip");
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpProxyUser = proxyUser;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConnectionTimeout = connectionTimeout;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpReadTimeout = readTimeout;
    }

    @Override
    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final int getHttpMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    protected final void setHttpMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    @Override
    public final int getHttpDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    protected final void setHttpDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    @Override
    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
        this.fixRestBaseURL();
    }

    @Override
    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.oAuthConsumerSecret = oAuthConsumerSecret;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
    }

    @Override
    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int asyncNumThreads) {
        this.asyncNumThreads = asyncNumThreads;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String clientURL) {
        this.clientURL = clientURL;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_REST_BASE_URL.equals(ConfigurationBase.fixURL(false, this.restBaseURL))) {
            this.restBaseURL = null != this.oAuthConsumerKey && null != this.oAuthConsumerSecret ? ConfigurationBase.fixURL(false, this.restBaseURL) : ConfigurationBase.fixURL(this.useSSL, this.restBaseURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
        if (DEFAULT_OAUTH_AUTHENTICATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthenticationURL))) {
            this.oAuthAuthenticationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthenticationURL);
        }
        if (DEFAULT_OAUTH_AUTHORIZATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthorizationURL))) {
            this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthorizationURL);
        }
        if (DEFAULT_OAUTH_REQUEST_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthRequestTokenURL))) {
            this.oAuthRequestTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthRequestTokenURL);
        }
    }

    @Override
    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    protected final void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    @Override
    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String streamBaseURL) {
        this.streamBaseURL = streamBaseURL;
    }

    @Override
    public String getUserStreamBaseURL() {
        return this.userStreamBaseURL;
    }

    protected final void setUserStreamBaseURL(String siteStreamBaseURL) {
        this.userStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getSiteStreamBaseURL() {
        return this.siteStreamBaseURL;
    }

    protected final void setSiteStreamBaseURL(String siteStreamBaseURL) {
        this.siteStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.oAuthRequestTokenURL = oAuthRequestTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.oAuthAuthenticationURL = oAuthAuthenticationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getDispatcherImpl() {
        return this.dispatcherImpl;
    }

    protected final void setDispatcherImpl(String dispatcherImpl) {
        this.dispatcherImpl = dispatcherImpl;
    }

    @Override
    public boolean isIncludeRTsEnabled() {
        return this.includeRTsEnabled;
    }

    protected final void setIncludeRTsEnbled(boolean enabled) {
        this.includeRTsEnabled = enabled;
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntitiesEnabled;
    }

    protected final void setIncludeEntitiesEnbled(boolean enabled) {
        this.includeEntitiesEnabled = enabled;
    }

    @Override
    public boolean isUserStreamRepliesAllEnabled() {
        return this.userStreamRepliesAllEnabled;
    }

    protected final void setUserStreamRepliesAllEnabled(boolean enabled) {
        this.userStreamRepliesAllEnabled = enabled;
    }

    @Override
    public String getMediaProvider() {
        return this.mediaProvider;
    }

    protected final void setMediaProvider(String mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    @Override
    public String getMediaProviderAPIKey() {
        return this.mediaProviderAPIKey;
    }

    protected final void setMediaProviderAPIKey(String mediaProviderAPIKey) {
        this.mediaProviderAPIKey = mediaProviderAPIKey;
    }

    public int hashCode() {
        int result = this.debug ? 1 : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useSSL ? 1 : 0);
        result = 31 * result + (this.prettyDebug ? 1 : 0);
        result = 31 * result + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        result = 31 * result + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
        result = 31 * result + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
        result = 31 * result + this.httpProxyPort;
        result = 31 * result + this.httpConnectionTimeout;
        result = 31 * result + this.httpReadTimeout;
        result = 31 * result + this.httpStreamingReadTimeout;
        result = 31 * result + this.httpRetryCount;
        result = 31 * result + this.httpRetryIntervalSeconds;
        result = 31 * result + this.maxTotalConnections;
        result = 31 * result + this.defaultMaxPerRoute;
        result = 31 * result + (this.oAuthConsumerKey != null ? this.oAuthConsumerKey.hashCode() : 0);
        result = 31 * result + (this.oAuthConsumerSecret != null ? this.oAuthConsumerSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenSecret != null ? this.oAuthAccessTokenSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthRequestTokenURL != null ? this.oAuthRequestTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthenticationURL != null ? this.oAuthAuthenticationURL.hashCode() : 0);
        result = 31 * result + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        result = 31 * result + (this.searchBaseURL != null ? this.searchBaseURL.hashCode() : 0);
        result = 31 * result + (this.streamBaseURL != null ? this.streamBaseURL.hashCode() : 0);
        result = 31 * result + (this.userStreamBaseURL != null ? this.userStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.siteStreamBaseURL != null ? this.siteStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.dispatcherImpl != null ? this.dispatcherImpl.hashCode() : 0);
        result = 31 * result + this.asyncNumThreads;
        result = 31 * result + (this.includeRTsEnabled ? 1 : 0);
        result = 31 * result + (this.userStreamRepliesAllEnabled ? 1 : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.clientURL != null ? this.clientURL.hashCode() : 0);
        result = 31 * result + (this.IS_DALVIK ? 1 : 0);
        result = 31 * result + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        result = 31 * result + (this.mediaProvider != null ? this.mediaProvider.hashCode() : 0);
        result = 31 * result + (this.mediaProviderAPIKey != null ? this.mediaProviderAPIKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("ConfigurationBase{debug=").append(this.debug).append(", userAgent='").append(this.userAgent).append('\'').append(", user='").append(this.user).append('\'').append(", password='").append(this.password).append('\'').append(", useSSL=").append(this.useSSL).append(", httpProxyHost='").append(this.httpProxyHost).append('\'').append(", httpProxyUser='").append(this.httpProxyUser).append('\'').append(", httpProxyPassword='").append(this.httpProxyPassword).append('\'').append(", httpProxyPort=").append(this.httpProxyPort).append(", httpConnectionTimeout=").append(this.httpConnectionTimeout).append(", httpReadTimeout=").append(this.httpReadTimeout).append(", httpStreamingReadTimeout=").append(this.httpStreamingReadTimeout).append(", httpRetryCount=").append(this.httpRetryCount).append(", httpRetryIntervalSeconds=").append(this.httpRetryIntervalSeconds).append(", maxTotalConnections=").append(this.maxTotalConnections).append(", defaultMaxPerRoute=").append(this.defaultMaxPerRoute).append(", oAuthConsumerKey='").append(this.oAuthConsumerKey).append('\'').append(", oAuthConsumerSecret='").append(this.oAuthConsumerSecret).append('\'').append(", oAuthAccessToken='").append(this.oAuthAccessToken).append('\'').append(", oAuthAccessTokenSecret='").append(this.oAuthAccessTokenSecret).append('\'').append(", oAuthRequestTokenURL='").append(this.oAuthRequestTokenURL).append('\'').append(", oAuthAuthorizationURL='").append(this.oAuthAuthorizationURL).append('\'').append(", oAuthAccessTokenURL='").append(this.oAuthAccessTokenURL).append('\'').append(", oAuthAuthenticationURL='").append(this.oAuthAuthenticationURL).append('\'').append(", restBaseURL='").append(this.restBaseURL).append('\'').append(", searchBaseURL='").append(this.searchBaseURL).append('\'').append(", streamBaseURL='").append(this.streamBaseURL).append('\'').append(", userStreamBaseURL='").append(this.userStreamBaseURL).append('\'').append(", siteStreamBaseURL='").append(this.siteStreamBaseURL).append('\'').append(", dispatcherImpl='").append(this.dispatcherImpl).append('\'').append(", asyncNumThreads=").append(this.asyncNumThreads).append(", includeRTsEnabled=").append(this.includeRTsEnabled).append(", includeEntitiesEnabled=").append(this.includeEntitiesEnabled).append(", userStreamRepliesAllEnabled=").append(this.userStreamRepliesAllEnabled).append(", clientVersion='").append(this.clientVersion).append('\'').append(", clientURL='").append(this.clientURL).append('\'').append(", IS_DALVIK=").append(this.IS_DALVIK).append(", requestHeaders=").append(this.requestHeaders).append(", mediaProvider=").append(this.mediaProvider).append(", mediaProviderAPIKey=").append(this.mediaProviderAPIKey).append('}').toString();
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return new StringBuffer().append("https://").append(hostAndLater).toString();
        }
        return new StringBuffer().append("http://").append(hostAndLater).toString();
    }

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
    }
}

