/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.Serializable;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.HttpResponse;
import twitter4j.http.OAuthSupport;
import twitter4j.http.OAuthToken;

public class RequestToken
extends OAuthToken
implements Serializable {
    private final Configuration conf = ConfigurationContext.getInstance();
    private OAuthSupport oauth;
    private static final long serialVersionUID = -8214365845469757952L;

    RequestToken(HttpResponse res, OAuthSupport oauth) throws TwitterException {
        super(res);
        this.oauth = oauth;
    }

    public RequestToken(String token, String tokenSecret) {
        super(token, tokenSecret);
    }

    RequestToken(String token, String tokenSecret, OAuthSupport oauth) {
        super(token, tokenSecret);
        this.oauth = oauth;
    }

    public AccessToken getAccessToken() throws TwitterException {
        return this.oauth.getOAuthAccessToken();
    }

    public AccessToken getAccessToken(String oauth_verifier) throws TwitterException {
        return this.oauth.getOAuthAccessToken(oauth_verifier);
    }

    public String getAuthorizationURL() {
        return this.conf.getOAuthAuthorizationURL() + "?oauth_token=" + this.getToken();
    }

    public String getAuthenticationURL() {
        return this.conf.getOAuthAuthenticationURL() + "?oauth_token=" + this.getToken();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestToken that = (RequestToken)o;
        return !(this.oauth != null ? !this.oauth.equals(that.oauth) : that.oauth != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oauth != null ? this.oauth.hashCode() : 0);
        return result;
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ String getParameter(String x0) {
        return super.getParameter(x0);
    }

    public /* synthetic */ String getTokenSecret() {
        return super.getTokenSecret();
    }

    public /* synthetic */ String getToken() {
        return super.getToken();
    }
}

