/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

final class RequestMethod
implements Serializable {
    private final String name;
    private static final Map<String, RequestMethod> instances = new HashMap<String, RequestMethod>(5);
    public static final RequestMethod GET = new RequestMethod("GET");
    public static final RequestMethod POST = new RequestMethod("POST");
    public static final RequestMethod DELETE = new RequestMethod("DELETE");
    public static final RequestMethod HEAD = new RequestMethod("HEAD");
    public static final RequestMethod PUT = new RequestMethod("PUT");
    private static final long serialVersionUID = -4399222582680270381L;

    private RequestMethod(String name) {
        this.name = name;
        instances.put(name, this);
    }

    public final String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestMethod)) {
            return false;
        }
        RequestMethod that = (RequestMethod)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "RequestMethod{name='" + this.name + '\'' + '}';
    }

    private static RequestMethod getInstance(String name) {
        return instances.get(name);
    }

    private Object readResolve() throws ObjectStreamException {
        return RequestMethod.getInstance(this.name);
    }
}

