/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpParameter
implements Comparable,
Serializable {
    String name = null;
    String value = null;
    File file = null;
    private static final long serialVersionUID = -8708108746980739212L;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public HttpParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpParameter(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public HttpParameter(String name, int value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, long value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, double value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public HttpParameter(String name, boolean value) {
        this.name = name;
        this.value = String.valueOf(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isFile() {
        return null != this.file;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String extensions = this.file.getName();
        int index = extensions.lastIndexOf(".");
        String contentType = -1 == index ? OCTET : ((extensions = extensions.substring(extensions.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(extensions) ? GIF : ("png".equals(extensions) ? PNG : ("jpg".equals(extensions) ? JPEG : OCTET))) : (extensions.length() == 4 ? ("jpeg".equals(extensions) ? JPEG : OCTET) : OCTET));
        return contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpParameter)) {
            return false;
        }
        HttpParameter that = (HttpParameter)o;
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    static boolean containsFile(HttpParameter[] params) {
        boolean containsFile = false;
        if (null == params) {
            return false;
        }
        for (HttpParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    static boolean containsFile(List<HttpParameter> params) {
        boolean containsFile = false;
        for (HttpParameter param : params) {
            if (!param.isFile()) continue;
            containsFile = true;
            break;
        }
        return containsFile;
    }

    public static HttpParameter[] getParameterArray(String name, String value) {
        return new HttpParameter[]{new HttpParameter(name, value)};
    }

    public static HttpParameter[] getParameterArray(String name, int value) {
        return HttpParameter.getParameterArray(name, String.valueOf(value));
    }

    public static HttpParameter[] getParameterArray(String name1, String value1, String name2, String value2) {
        return new HttpParameter[]{new HttpParameter(name1, value1), new HttpParameter(name2, value2)};
    }

    public static HttpParameter[] getParameterArray(String name1, int value1, String name2, int value2) {
        return HttpParameter.getParameterArray(name1, String.valueOf(value1), name2, String.valueOf(value2));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + '}';
    }

    public int compareTo(Object o) {
        HttpParameter that = (HttpParameter)o;
        int compared = this.name.compareTo(that.name);
        if (0 == compared) {
            compared = this.value.compareTo(that.value);
        }
        return compared;
    }

    public static String encodeParameters(HttpParameter[] httpParams) {
        if (null == httpParams) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < httpParams.length; ++j) {
            if (httpParams[j].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParams[j].name + "]should be text");
            }
            if (j != 0) {
                buf.append("&");
            }
            try {
                buf.append(URLEncoder.encode(httpParams[j].name, "UTF-8")).append("=").append(URLEncoder.encode(httpParams[j].value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buf.toString();
    }
}

