/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import twitter4j.PagableResponseList;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.http.HttpResponse;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserJSONImpl
extends TwitterResponseImpl
implements User,
Serializable {
    private int id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Date statusCreatedAt;
    private long statusId = -1L;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private long statusInReplyToStatusId = -1L;
    private int statusInReplyToUserId = -1;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private boolean profileBackgroundTiled;
    private int statusesCount;
    private boolean isGeoEnabled;
    private boolean isVerified;
    private static final long serialVersionUID = -6345893237975349030L;

    UserJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    UserJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.id = ParseUtil.getInt("id", json);
            this.name = ParseUtil.getRawString("name", json);
            this.screenName = ParseUtil.getRawString("screen_name", json);
            this.location = ParseUtil.getRawString("location", json);
            this.description = ParseUtil.getRawString("description", json);
            this.profileImageUrl = ParseUtil.getRawString("profile_image_url", json);
            this.url = ParseUtil.getRawString("url", json);
            this.isProtected = ParseUtil.getBoolean("protected", json);
            this.isGeoEnabled = ParseUtil.getBoolean("geo_enabled", json);
            this.isVerified = ParseUtil.getBoolean("verified", json);
            this.followersCount = ParseUtil.getInt("followers_count", json);
            this.profileBackgroundColor = ParseUtil.getRawString("profile_background_color", json);
            this.profileTextColor = ParseUtil.getRawString("profile_text_color", json);
            this.profileLinkColor = ParseUtil.getRawString("profile_link_color", json);
            this.profileSidebarFillColor = ParseUtil.getRawString("profile_sidebar_fill_color", json);
            this.profileSidebarBorderColor = ParseUtil.getRawString("profile_sidebar_border_color", json);
            this.friendsCount = ParseUtil.getInt("friends_count", json);
            this.createdAt = ParseUtil.getDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.favouritesCount = json.getInt("favourites_count");
            this.utcOffset = ParseUtil.getInt("utc_offset", json);
            this.timeZone = ParseUtil.getRawString("time_zone", json);
            this.profileBackgroundImageUrl = ParseUtil.getRawString("profile_background_image_url", json);
            this.profileBackgroundTiled = ParseUtil.getBoolean("profile_background_tile", json);
            this.statusesCount = ParseUtil.getInt("statuses_count", json);
            if (!json.isNull("status")) {
                JSONObject status = json.getJSONObject("status");
                this.statusCreatedAt = ParseUtil.getDate(status.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
                this.statusId = status.getLong("id");
                this.statusText = status.getString("text");
                this.statusSource = status.getString("source");
                this.statusTruncated = status.getBoolean("truncated");
                this.statusInReplyToStatusId = ParseUtil.getLong("in_reply_to_status_id", status);
                this.statusInReplyToUserId = ParseUtil.getInt("in_reply_to_user_id", status);
                this.statusFavorited = status.getBoolean("favorited");
                this.statusInReplyToScreenName = status.getString("in_reply_to_screen_name");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public int getFollowersCount() {
        return this.followersCount;
    }

    @Override
    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    @Override
    public long getStatusId() {
        return this.statusId;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public String getStatusSource() {
        return this.statusSource;
    }

    @Override
    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    @Override
    public long getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    @Override
    public int getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    @Override
    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    @Override
    public String getStatusInReplyToScreenName() {
        return -1 != this.statusInReplyToUserId ? this.statusInReplyToScreenName : null;
    }

    @Override
    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    @Override
    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    @Override
    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    @Override
    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    @Override
    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    @Override
    public int getFriendsCount() {
        return this.friendsCount;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    @Override
    public int getUtcOffset() {
        return this.utcOffset;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getProfileBackgroundImageUrl() {
        return this.profileBackgroundImageUrl;
    }

    @Override
    public boolean isProfileBackgroundTiled() {
        return this.profileBackgroundTiled;
    }

    @Override
    public int getStatusesCount() {
        return this.statusesCount;
    }

    @Override
    public boolean isGeoEnabled() {
        return this.isGeoEnabled;
    }

    @Override
    public boolean isVerified() {
        return this.isVerified;
    }

    static PagableResponseList<User> createPagableUserList(HttpResponse res) throws TwitterException {
        try {
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("users");
            int size = list.length();
            PagableResponseList<User> users = new PagableResponseList<User>(size, json, res);
            for (int i = 0; i < size; ++i) {
                users.add(new UserJSONImpl(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    static ResponseList<User> createUserList(HttpResponse res) throws TwitterException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseList<User> users = new ResponseList<User>(size, res);
            for (int i = 0; i < size; ++i) {
                users.add(new UserJSONImpl(list.getJSONObject(i)));
            }
            return users;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId() == this.id;
    }

    public String toString() {
        return "UserJSONImpl{, id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", statusCreatedAt=" + this.statusCreatedAt + ", statusId=" + this.statusId + ", statusText='" + this.statusText + '\'' + ", statusSource='" + this.statusSource + '\'' + ", statusTruncated=" + this.statusTruncated + ", statusInReplyToStatusId=" + this.statusInReplyToStatusId + ", statusInReplyToUserId=" + this.statusInReplyToUserId + ", statusFavorited=" + this.statusFavorited + ", statusInReplyToScreenName='" + this.statusInReplyToScreenName + '\'' + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundTile='" + this.profileBackgroundTiled + '\'' + ", statusesCount=" + this.statusesCount + ", geoEnabled=" + this.isGeoEnabled + ", verified=" + this.isVerified + '}';
    }
}

