/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.TwitterFactoryBase;
import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.OAuthAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TwitterFactoryOAuthSupportBase<T>
extends TwitterFactoryBase<T> {
    protected TwitterFactoryOAuthSupportBase() {
    }

    protected TwitterFactoryOAuthSupportBase(String configTreePath) {
        super(configTreePath);
    }

    @Override
    protected abstract T getInstance(Configuration var1, Authorization var2);

    protected TwitterFactoryOAuthSupportBase(Configuration conf) {
        super(conf);
    }

    public T getOAuthAuthorizedInstance(String consumerKey, String consumerSecret) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        return this.getOAuthSupportInstance(oauth);
    }

    public T getOAuthAuthorizedInstance(String consumerKey, String consumerSecret, AccessToken accessToken) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        oauth.setOAuthAccessToken(accessToken);
        return this.getOAuthSupportInstance(oauth);
    }

    public T getOAuthAuthorizedInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret, accessToken);
        return this.getOAuthSupportInstance(oauth);
    }

    protected abstract T getOAuthSupportInstance(Configuration var1, Authorization var2);

    public T getOAuthSupportInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }
}

