/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.conf.Configuration;
import twitter4j.http.Authorization;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.NullAuthorization;

abstract class TwitterBase
implements Serializable {
    protected final Configuration conf;
    protected Authorization auth;
    private static final long serialVersionUID = -3812176145960812140L;

    TwitterBase(Configuration conf) {
        this.conf = conf;
        this.initBasicAuthorization(conf.getUser(), conf.getPassword());
    }

    TwitterBase(Configuration conf, String userId, String password) {
        this.conf = conf;
        this.initBasicAuthorization(userId, password);
    }

    private void initBasicAuthorization(String screenName, String password) {
        if (null != screenName && null != password) {
            this.auth = new BasicAuthorization(screenName, password);
        }
        if (null == this.auth) {
            this.auth = NullAuthorization.getInstance();
        }
    }

    TwitterBase(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
    }

    public boolean isBasicAuthEnabled() {
        return this.auth instanceof BasicAuthorization && this.auth.isEnabled();
    }

    protected void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
    }

    protected void ensureBasicEnabled() {
        if (!(this.auth instanceof BasicAuthorization)) {
            throw new IllegalStateException("user ID/password combination not supplied");
        }
    }

    protected void ensureBasicNotEnabled() {
        if (!(this.auth instanceof BasicAuthorization)) {
            throw new IllegalStateException("user ID/password combination not supplied");
        }
    }

    public Authorization getAuthorization() {
        return this.auth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterBase)) {
            return false;
        }
        TwitterBase that = (TwitterBase)o;
        return this.auth.equals(that.auth);
    }

    public int hashCode() {
        return this.auth != null ? this.auth.hashCode() : 0;
    }

    public String toString() {
        return "TwitterBase{auth=" + this.auth + '}';
    }
}

