/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Date;
import twitter4j.GeoLocation;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.http.HttpResponse;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Status retweetedStatus;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    StatusJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    StatusJSONImpl(JSONObject json) throws TwitterException, JSONException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = ParseUtil.getLong("id", json);
        this.text = ParseUtil.getUnescapedString("text", json);
        this.source = ParseUtil.getUnescapedString("source", json);
        this.createdAt = ParseUtil.getDate("created_at", json);
        this.isTruncated = ParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = ParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = ParseUtil.getInt("in_reply_to_user_id", json);
        this.isFavorited = ParseUtil.getBoolean("favorited", json);
        this.inReplyToScreenName = ParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        this.geoLocation = GeoLocation.getInstance(json);
        if (!json.isNull("retweeted_status")) {
            try {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return null != this.retweetedStatus;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    static ResponseList<Status> createStatusList(HttpResponse res) throws TwitterException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseList<Status> statuses = new ResponseList<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                statuses.add(new StatusJSONImpl(list.getJSONObject(i)));
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    public String toString() {
        return "StatusJSONImpl{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", geoLocation=" + this.geoLocation + ", retweetedStatus=" + this.retweetedStatus + ", user=" + this.user + '}';
    }
}

