/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.http.HttpResponse;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SavedSearchJSONImpl
extends TwitterResponseImpl
implements SavedSearch {
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private int id;
    private static final long serialVersionUID = 3083819860391598212L;

    SavedSearchJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    SavedSearchJSONImpl(JSONObject savedSearch) throws TwitterException {
        this.init(savedSearch);
    }

    static ResponseList<SavedSearch> createSavedSearchList(HttpResponse res) throws TwitterException {
        JSONArray json = res.asJSONArray();
        try {
            ResponseList<SavedSearch> savedSearches = new ResponseList<SavedSearch>(json.length(), res);
            for (int i = 0; i < json.length(); ++i) {
                savedSearches.add(new SavedSearchJSONImpl(json.getJSONObject(i)));
            }
            return savedSearches;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + res.asString(), jsone);
        }
    }

    private void init(JSONObject savedSearch) throws TwitterException {
        this.createdAt = ParseUtil.getDate("created_at", savedSearch, "EEE MMM dd HH:mm:ss z yyyy");
        this.query = ParseUtil.getUnescapedString("query", savedSearch);
        this.position = ParseUtil.getInt("position", savedSearch);
        this.name = ParseUtil.getUnescapedString("name", savedSearch);
        this.id = ParseUtil.getInt("id", savedSearch);
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SavedSearch)) {
            return false;
        }
        SavedSearch that = (SavedSearch)o;
        return this.id == that.getId();
    }

    public int hashCode() {
        int result = this.createdAt.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.position;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        return "SavedSearchJSONImpl{createdAt=" + this.createdAt + ", query='" + this.query + '\'' + ", position=" + this.position + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

