/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import twitter4j.TwitterException;
import twitter4j.http.HTMLEntity;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

final class ParseUtil {
    private static Map<String, SimpleDateFormat> formatMap = new HashMap<String, SimpleDateFormat>();

    private ParseUtil() {
        throw new AssertionError();
    }

    static String getUnescapedString(String str, JSONObject json) {
        return HTMLEntity.unescape(ParseUtil.getRawString(str, json));
    }

    static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = ParseUtil.getRawString(name, json);
        if (null != returnValue) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    static Date getDate(String name, JSONObject json) throws TwitterException {
        return ParseUtil.getDate(name, json, "EEE MMM d HH:mm:ss z yyyy");
    }

    static Date getDate(String name, JSONObject json, String format) throws TwitterException {
        String dateStr = ParseUtil.getUnescapedString(name, json);
        if ("null".equals(dateStr)) {
            return null;
        }
        return ParseUtil.getDate(dateStr, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date getDate(String name, String format) throws TwitterException {
        SimpleDateFormat sdf = formatMap.get(format);
        if (null == sdf) {
            sdf = new SimpleDateFormat(format, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatMap.put(format, sdf);
        }
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.parse(name);
            }
        }
        catch (ParseException pe) {
            throw new TwitterException("Unexpected format(" + name + ") returned from twitter.com");
        }
    }

    static int getInt(String name, JSONObject elem) {
        String str2 = ParseUtil.getRawString(name, elem);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1;
        }
        return Integer.valueOf(str2);
    }

    static long getLong(String name, JSONObject json) {
        String str2 = ParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1L;
        }
        return Long.valueOf(str2);
    }

    static double getDouble(String name, JSONObject json) {
        String str2 = ParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.valueOf(str2);
    }

    static boolean getBoolean(String name, JSONObject json) {
        String str = ParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }
}

