/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.http.HttpParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paging
implements Serializable {
    private int page = -1;
    private int count = -1;
    private long sinceId = -1L;
    private long maxId = -1L;
    private static final long serialVersionUID = -3285857427993796670L;
    static char[] S = new char[]{'s'};
    static char[] SMCP = new char[]{'s', 'm', 'c', 'p'};
    static final String COUNT = "count";
    static final String PER_PAGE = "per_page";
    private static HttpParameter[] NULL_PARAMETER_ARRAY = new HttpParameter[0];
    private static List<HttpParameter> NULL_PARAMETER_LIST = new ArrayList<HttpParameter>(0);

    List<HttpParameter> asPostParameterList() {
        return this.asPostParameterList(SMCP, COUNT);
    }

    HttpParameter[] asPostParameterArray() {
        List<HttpParameter> list = this.asPostParameterList(SMCP, COUNT);
        if (list.size() == 0) {
            return NULL_PARAMETER_ARRAY;
        }
        return list.toArray(new HttpParameter[list.size()]);
    }

    List<HttpParameter> asPostParameterList(char[] supportedParams) {
        return this.asPostParameterList(supportedParams, COUNT);
    }

    List<HttpParameter> asPostParameterList(char[] supportedParams, String perPageParamName) {
        ArrayList<HttpParameter> pagingParams = new ArrayList<HttpParameter>(supportedParams.length);
        this.addPostParameter(supportedParams, 's', pagingParams, "since_id", this.getSinceId());
        this.addPostParameter(supportedParams, 'm', pagingParams, "max_id", this.getMaxId());
        this.addPostParameter(supportedParams, 'c', pagingParams, perPageParamName, this.getCount());
        this.addPostParameter(supportedParams, 'p', pagingParams, "page", this.getPage());
        if (pagingParams.size() == 0) {
            return NULL_PARAMETER_LIST;
        }
        return pagingParams;
    }

    HttpParameter[] asPostParameterArray(char[] supportedParams, String perPageParamName) {
        ArrayList<HttpParameter> pagingParams = new ArrayList<HttpParameter>(supportedParams.length);
        this.addPostParameter(supportedParams, 's', pagingParams, "since_id", this.getSinceId());
        this.addPostParameter(supportedParams, 'm', pagingParams, "max_id", this.getMaxId());
        this.addPostParameter(supportedParams, 'c', pagingParams, perPageParamName, this.getCount());
        this.addPostParameter(supportedParams, 'p', pagingParams, "page", this.getPage());
        if (pagingParams.size() == 0) {
            return NULL_PARAMETER_ARRAY;
        }
        return pagingParams.toArray(new HttpParameter[pagingParams.size()]);
    }

    private void addPostParameter(char[] supportedParams, char paramKey, List<HttpParameter> pagingParams, String paramName, long paramValue) {
        boolean supported = false;
        for (char supportedParam : supportedParams) {
            if (supportedParam != paramKey) continue;
            supported = true;
            break;
        }
        if (!supported && -1L != paramValue) {
            throw new IllegalStateException("Paging parameter [" + paramName + "] is not supported with this operation.");
        }
        if (-1L != paramValue) {
            pagingParams.add(new HttpParameter(paramName, String.valueOf(paramValue)));
        }
    }

    public Paging() {
    }

    public Paging(int page) {
        this.setPage(page);
    }

    public Paging(long sinceId) {
        this.setSinceId(sinceId);
    }

    public Paging(int page, int count) {
        this(page);
        this.setCount(count);
    }

    public Paging(int page, long sinceId) {
        this(page);
        this.setSinceId(sinceId);
    }

    public Paging(int page, int count, long sinceId) {
        this(page, count);
        this.setSinceId(sinceId);
    }

    public Paging(int page, int count, long sinceId, long maxId) {
        this(page, count, sinceId);
        this.setMaxId(maxId);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page should be positive integer. passed:" + page);
        }
        this.page = page;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count should be positive integer. passed:" + count);
        }
        this.count = count;
    }

    public Paging count(int count) {
        this.setCount(count);
        return this;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        if (sinceId < 1L) {
            throw new IllegalArgumentException("since_id should be positive integer. passed:" + sinceId);
        }
        this.sinceId = sinceId;
    }

    public Paging sinceId(long sinceId) {
        this.setSinceId(sinceId);
        return this;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        if (maxId < 1L) {
            throw new IllegalArgumentException("max_id should be positive integer. passed:" + maxId);
        }
        this.maxId = maxId;
    }

    public Paging maxId(long maxId) {
        this.setMaxId(maxId);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging paging = (Paging)o;
        if (this.count != paging.count) {
            return false;
        }
        if (this.maxId != paging.maxId) {
            return false;
        }
        if (this.page != paging.page) {
            return false;
        }
        return this.sinceId == paging.sinceId;
    }

    public int hashCode() {
        int result = this.page;
        result = 31 * result + this.count;
        result = 31 * result + (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        return result;
    }

    public String toString() {
        return "Paging{page=" + this.page + ", count=" + this.count + ", sinceId=" + this.sinceId + ", maxId=" + this.maxId + '}';
    }
}

