/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Date;
import twitter4j.DirectMessage;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.http.HttpResponse;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DirectMessageJSONImpl
extends TwitterResponseImpl
implements DirectMessage,
Serializable {
    private int id;
    private String text;
    private int senderId;
    private int recipientId;
    private Date createdAt;
    private String senderScreenName;
    private String recipientScreenName;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessageJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    DirectMessageJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = ParseUtil.getInt("id", json);
        this.text = ParseUtil.getUnescapedString("text", json);
        this.senderId = ParseUtil.getInt("sender_id", json);
        this.recipientId = ParseUtil.getInt("recipient_id", json);
        this.createdAt = ParseUtil.getDate("created_at", json);
        this.senderScreenName = ParseUtil.getUnescapedString("sender_screen_name", json);
        this.recipientScreenName = ParseUtil.getUnescapedString("recipient_screen_name", json);
        try {
            this.sender = new UserJSONImpl(json.getJSONObject("sender"));
            this.recipient = new UserJSONImpl(json.getJSONObject("recipient"));
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getSenderId() {
        return this.senderId;
    }

    @Override
    public int getRecipientId() {
        return this.recipientId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getSenderScreenName() {
        return this.senderScreenName;
    }

    @Override
    public String getRecipientScreenName() {
        return this.recipientScreenName;
    }

    @Override
    public User getSender() {
        return this.sender;
    }

    @Override
    public User getRecipient() {
        return this.recipient;
    }

    static ResponseList<DirectMessage> createDirectMessageList(HttpResponse res) throws TwitterException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseList<DirectMessage> directMessages = new ResponseList<DirectMessage>(size, res);
            for (int i = 0; i < size; ++i) {
                directMessages.add(new DirectMessageJSONImpl(list.getJSONObject(i)));
            }
            return directMessages;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).getId() == this.id;
    }

    public String toString() {
        return "DirectMessageJSONImpl{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.senderId + ", recipient_id=" + this.recipientId + ", created_at=" + this.createdAt + ", sender_screen_name='" + this.senderScreenName + '\'' + ", recipient_screen_name='" + this.recipientScreenName + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

