/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import twitter4j.AccountSettings;
import twitter4j.AsyncTwitter;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Dispatcher;
import twitter4j.DispatcherFactory;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.OEmbed;
import twitter4j.OEmbedRequest;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.TwitterListener;
import twitter4j.TwitterMethod;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.api.HelpResources;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuth2Token;
import twitter4j.auth.RequestToken;
import twitter4j.conf.Configuration;

class AsyncTwitterImpl
extends TwitterBaseImpl
implements AsyncTwitter {
    private static final long serialVersionUID = 6491978434917152443L;
    private final Twitter twitter;
    private final List<TwitterListener> listeners = new ArrayList<TwitterListener>();
    private static volatile transient Dispatcher dispatcher;

    AsyncTwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.twitter = new TwitterFactory(conf).getInstance(auth);
    }

    @Override
    public void addListener(TwitterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void getMentions() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MENTIONS_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getMentionsTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getMentions(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MENTIONS_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getMentionsTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMentions((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserTimeline(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserTimeline(final long userId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserTimeline(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserTimeline(String screenName) {
        this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public void getUserTimeline(long userId) {
        this.getUserTimeline(userId, new Paging());
    }

    @Override
    public void getUserTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getHomeTimeline() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.HOME_TIMELINE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getHomeTimeline();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getHomeTimeline(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.HOME_TIMELINE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getHomeTimeline(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotHomeTimeline((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getRetweetsOfMe() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS_OF_ME, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetsOfMe();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getRetweetsOfMe(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS_OF_ME, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweetsOfMe(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweetsOfMe((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getRetweets(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEETS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getRetweets(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRetweets((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showStatus(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.showStatus(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowStatus(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyStatus(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.destroyStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedStatus(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateStatus(final String statusText) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.updateStatus(statusText);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateStatus(final StatusUpdate latestStatus) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.updateStatus(latestStatus);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedStatus(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void retweetStatus(final long statusId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.retweetStatus(statusId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.retweetedStatus(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOEmbed(final OEmbedRequest req) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OEMBED, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                OEmbed oembed = AsyncTwitterImpl.this.twitter.getOEmbed(req);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOEmbed(oembed);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void lookup(final long ... ids) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RETWEET_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.lookup(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedup((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void search(final Query query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                QueryResult result = AsyncTwitterImpl.this.twitter.search(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searched(result);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getDirectMessages() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getSentDirectMessages() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getSentDirectMessages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getSentDirectMessages(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SENT_DIRECT_MESSAGES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList directMessages = AsyncTwitterImpl.this.twitter.getSentDirectMessages(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSentDirectMessages((ResponseList<DirectMessage>)directMessages);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showDirectMessage(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.showDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotDirectMessage(directMessage);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyDirectMessage(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.destroyDirectMessage(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedDirectMessage(directMessage);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void sendDirectMessage(final long userId, final String text) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.sendDirectMessage(userId, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void sendDirectMessage(final String screenName, final String text) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEND_DIRECT_MESSAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                DirectMessage directMessage = AsyncTwitterImpl.this.twitter.sendDirectMessage(screenName, text);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.sentDirectMessage(directMessage);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFriendsIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFriendsIDs(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFriendsIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFriendsIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFollowersIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFollowersIDs(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFollowersIDs(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getFollowersIDs(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void lookupFriendships(final long ... ids) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList friendships = AsyncTwitterImpl.this.twitter.lookupFriendships(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships((ResponseList<Friendship>)friendships);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void lookupFriendships(final String ... screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList friendships = AsyncTwitterImpl.this.twitter.lookupFriendships(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedUpFriendships((ResponseList<Friendship>)friendships);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getIncomingFriendships(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.INCOMING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getIncomingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotIncomingFriendships(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOutgoingFriendships(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OUTGOING_FRIENDSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getOutgoingFriendships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOutgoingFriendships(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createFriendship(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createFriendship(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createFriendship(final long userId, final boolean follow) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(userId, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createFriendship(final String screenName, final boolean follow) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createFriendship(screenName, follow);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyFriendship(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyFriendship(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyFriendship(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyFriendship(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFriendship(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateFriendship(final long userId, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.updateFriendship(userId, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateFriendship(final String screenName, final boolean enableDeviceNotification, final boolean retweet) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.updateFriendship(screenName, enableDeviceNotification, retweet);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedFriendship(relationship);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showFriendship(final long sourceId, final long targetId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.showFriendship(sourceId, targetId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showFriendship(final String sourceScreenName, final String targetScreenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_FRIENDSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Relationship relationship = AsyncTwitterImpl.this.twitter.showFriendship(sourceScreenName, targetScreenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowFriendship(relationship);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFriendsList(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFriendsList(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsList((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFriendsList(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FRIENDS_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFriendsList(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFriendsList((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFollowersList(final long userId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFollowersList(userId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersList((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFollowersList(final String screenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FOLLOWERS_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getFollowersList(screenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFollowersList((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getAccountSettings() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.ACCOUNT_SETTINGS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountSettings accountSettings = AsyncTwitterImpl.this.twitter.getAccountSettings();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAccountSettings(accountSettings);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void verifyCredentials() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.VERIFY_CREDENTIALS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.verifyCredentials();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.verifiedCredentials(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateAccountSettings(final Integer trend_locationWoeid, final Boolean sleep_timeEnabled, final String start_sleepTime, final String end_sleepTime, final String time_zone, final String lang) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_ACCOUNT_SETTINGS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccountSettings accountSettings = AsyncTwitterImpl.this.twitter.updateAccountSettings(trend_locationWoeid, sleep_timeEnabled, start_sleepTime, end_sleepTime, time_zone, lang);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedAccountSettings(accountSettings);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfile(final String name, final String url, final String location, final String description) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfile(name, url, location, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfile(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileBackgroundImage(final File image, final boolean tile) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileBackgroundImage(final InputStream image, final boolean tile) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BACKGROUND_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileBackgroundImage(image, tile);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBackgroundImage(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileColors(final String profileBackgroundColor, final String profileTextColor, final String profileLinkColor, final String profileSidebarFillColor, final String profileSidebarBorderColor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_COLORS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileColors(profileBackgroundColor, profileTextColor, profileLinkColor, profileSidebarFillColor, profileSidebarBorderColor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileColors(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileImage(final File image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileImage(final InputStream image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_IMAGE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.updateProfileImage(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileImage(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getBlocksList() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCK_LIST, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getBlocksList();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlocksList((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getBlocksList(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCK_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getBlocksList(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlocksList((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getBlocksIDs() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCK_LIST_IDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getBlocksIDs();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getBlocksIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.BLOCK_LIST_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getBlocksIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotBlockIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createBlock(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createBlock(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdBlock(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyBlock(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyBlock(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyBlock(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_BLOCK, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyBlock(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedBlock(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getMutesList(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MUTE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getMutesList(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMutesList((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getMutesIDs(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MUTE_LIST_IDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                IDs ids = AsyncTwitterImpl.this.twitter.getMutesIDs(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMuteIDs(ids);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createMute(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_MUTE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createMute(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdMute(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createMute(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_MUTE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.createMute(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdMute(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyMute(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_MUTE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyMute(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedMute(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyMute(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_MUTE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.destroyMute(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedMute(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void lookupUsers(final long ... ids) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.lookupUsers(ids);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void lookupUsers(final String ... screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LOOKUP_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.lookupUsers(screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.lookedupUsers((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUser(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUser(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUser(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUser(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserDetail(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void searchUsers(final String query, final int page) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH_USERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.searchUsers(query, page);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedUser((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getContributees(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CONTRIBUTEEES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getContributors(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotContributees((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getContributees(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CONTRIBUTEEES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getContributors(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotContributees((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getContributors(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CONTRIBUTORS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getContributors(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotContributors((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getContributors(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CONTRIBUTORS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getContributors(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotContributors((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void removeProfileBanner() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REMOVE_PROFILE_BANNER, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AsyncTwitterImpl.this.twitter.removeProfileBanner();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.removedProfileBanner();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileBanner(final File image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BANNER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AsyncTwitterImpl.this.twitter.updateProfileBanner(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBanner();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateProfileBanner(final InputStream image) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_PROFILE_BANNER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AsyncTwitterImpl.this.twitter.updateProfileBanner(image);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedProfileBanner();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getUserSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserSuggestions((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getSuggestedUserCategories() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SUGGESTED_USER_CATEGORIES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList categories = AsyncTwitterImpl.this.twitter.getSuggestedUserCategories();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSuggestedUserCategories((ResponseList<Category>)categories);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getMemberSuggestions(final String categorySlug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.MEMBER_SUGGESTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList users = AsyncTwitterImpl.this.twitter.getMemberSuggestions(categorySlug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotMemberSuggestions((ResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites(final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites(final long userId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(userId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getFavorites(final String screenName, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.FAVORITES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getFavorites(screenName, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotFavorites((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyFavorite(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.destroyFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedFavorite(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createFavorite(final long id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_FAVORITE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Status status = AsyncTwitterImpl.this.twitter.createFavorite(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdFavorite(status);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserLists(final long listOwnerUserId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList lists = AsyncTwitterImpl.this.twitter.getUserLists(listOwnerUserId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserLists((ResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserLists(final String listOwnerScreenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LISTS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList lists = AsyncTwitterImpl.this.twitter.getUserLists(listOwnerScreenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserLists((ResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListStatuses(final long listId, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserListStatuses(listId, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListStatuses(final long ownerId, final String slug, final Paging paging) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_STATUSES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList statuses = AsyncTwitterImpl.this.twitter.getUserListStatuses(ownerId, slug, paging);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListStatuses((ResponseList<Status>)statuses);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserListMember(final long listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserListMember(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserListMember(final long ownerId, final String slug, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserListMember(ownerId, slug, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserListMember(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListMemberships(final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListMemberships(cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMemberships((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListMemberships(String listMemberScreenName, long cursor) {
        this.getUserListMemberships(listMemberScreenName, cursor, false);
    }

    @Override
    public void getUserListMemberships(long listMemberId, long cursor) {
        this.getUserListMemberships(listMemberId, cursor, false);
    }

    @Override
    public void getUserListMemberships(final String listMemberScreenName, final long cursor, final boolean filterToOwnedLists) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListMemberships(listMemberScreenName, cursor, filterToOwnedLists);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMemberships((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListMemberships(final long listMemberId, final long cursor, final boolean filterToOwnedLists) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_MEMBERSHIPS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListMemberships(listMemberId, cursor, filterToOwnedLists);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMemberships((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListSubscribers(final long listId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_SUBSCRIBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListSubscribers(listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscribers((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListSubscribers(final long ownerId, final String slug, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_SUBSCRIBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListSubscribers(ownerId, slug, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscribers((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListSubscription(final long listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListSubscription(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.subscribedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListSubscription(final long ownerId, final String slug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListSubscription(ownerId, slug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.subscribedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserListSubscription(final long listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_SUBSCRIPTION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUserListSubscription(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListSubscription(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserListSubscription(final long ownerId, final String slug, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_SUBSCRIPTION, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUserListSubscription(ownerId, slug, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListSubscription(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserListSubscription(final long listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UNSUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserListSubscription(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.unsubscribedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserListSubscription(final long ownerId, final String slug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UNSUBSCRIBE_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserListSubscription(ownerId, slug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.unsubscribedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMembers(final long listId, final long ... userIds) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMembers(listId, userIds);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMembers(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMembers(final long ownerId, final String slug, final long ... userIds) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMembers(ownerId, slug, userIds);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMembers(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMembers(final long listId, final String ... screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMembers(listId, screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMembers(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMembers(final long ownerId, final String slug, final String ... screenNames) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMembers(ownerId, slug, screenNames);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMembers(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserListMembership(final long listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_MEMBERSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUserListMembership(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListMembership(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserListMembership(final long ownerId, final String slug, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CHECK_LIST_MEMBERSHIP, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.showUserListMembership(ownerId, slug, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.checkedUserListMembership(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListMembers(final long listId, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListMembers(listId, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListMembers(final long ownerId, final String slug, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LIST_MEMBERS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList users = AsyncTwitterImpl.this.twitter.getUserListMembers(ownerId, slug, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListMembers((PagableResponseList<User>)users);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMember(final long listId, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMember(listId, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMember(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserListMember(final long ownerId, final String slug, final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_LIST_MEMBER, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserListMember(ownerId, slug, userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserListMember(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserList(final long listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserList(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroyUserList(final long ownerId, final String slug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.destroyUserList(ownerId, slug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateUserList(final long listId, final String newListName, final boolean isPublicList, final String newDescription) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.updateUserList(listId, newListName, isPublicList, newDescription);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void updateUserList(final long ownerId, final String slug, final String newListName, final boolean isPublicList, final String newDescription) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.UPDATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.updateUserList(ownerId, slug, newListName, isPublicList, newDescription);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.updatedUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createUserList(final String listName, final boolean isPublicList, final String description) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.createUserList(listName, isPublicList, description);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserList(final long listId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.showUserList(listId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showUserList(final long ownerId, final String slug) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SHOW_USER_LIST, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                UserList list = AsyncTwitterImpl.this.twitter.showUserList(ownerId, slug);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotShowUserList(list);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getUserListSubscriptions(final String listOwnerScreenName, final long cursor) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.USER_LIST_SUBSCRIPTIONS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                PagableResponseList lists = AsyncTwitterImpl.this.twitter.getUserListSubscriptions(listOwnerScreenName, cursor);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotUserListSubscriptions((PagableResponseList<UserList>)lists);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getSavedSearches() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SAVED_SEARCHES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList savedSearches = AsyncTwitterImpl.this.twitter.getSavedSearches();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSavedSearches((ResponseList<SavedSearch>)savedSearches);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void showSavedSearch(final int id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SAVED_SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                SavedSearch savedSearch = AsyncTwitterImpl.this.twitter.showSavedSearch((long)id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSavedSearch(savedSearch);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void createSavedSearch(final String query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CREATE_SAVED_SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                SavedSearch savedSearch = AsyncTwitterImpl.this.twitter.createSavedSearch(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.createdSavedSearch(savedSearch);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void destroySavedSearch(final int id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.DESTROY_SAVED_SEARCH, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                SavedSearch savedSearch = AsyncTwitterImpl.this.twitter.destroySavedSearch((long)id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.destroyedSavedSearch(savedSearch);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getGeoDetails(final String id) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.GEO_DETAILS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Place place = AsyncTwitterImpl.this.twitter.getGeoDetails(id);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotGeoDetails(place);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void reverseGeoCode(final GeoQuery query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REVERSE_GEO_CODE, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList places = AsyncTwitterImpl.this.twitter.reverseGeoCode(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotReverseGeoCode((ResponseList<Place>)places);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void searchPlaces(final GeoQuery query) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SEARCH_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList places = AsyncTwitterImpl.this.twitter.searchPlaces(query);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.searchedPlaces((ResponseList<Place>)places);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getSimilarPlaces(final GeoLocation location, final String name, final String containedWithin, final String streetAddress) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.SIMILAR_PLACES, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList similarPlaces = AsyncTwitterImpl.this.twitter.getSimilarPlaces(location, name, containedWithin, streetAddress);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotSimilarPlaces((ResponseList<Place>)similarPlaces);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getPlaceTrends(final int woeid) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.PLACE_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Trends trends = AsyncTwitterImpl.this.twitter.getPlaceTrends(woeid);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPlaceTrends(trends);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getAvailableTrends() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.AVAILABLE_TRENDS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList locations = AsyncTwitterImpl.this.twitter.getAvailableTrends();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAvailableTrends((ResponseList<Location>)locations);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getClosestTrends(final GeoLocation location) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CLOSEST_TRENDS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList locations = AsyncTwitterImpl.this.twitter.getClosestTrends(location);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotClosestTrends((ResponseList<Location>)locations);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void reportSpam(final long userId) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.reportSpam(userId);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void reportSpam(final String screenName) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.REPORT_SPAM, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                User user = AsyncTwitterImpl.this.twitter.reportSpam(screenName);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.reportedSpam(user);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getAPIConfiguration() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.CONFIGURATION, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                TwitterAPIConfiguration apiConf = AsyncTwitterImpl.this.twitter.getAPIConfiguration();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotAPIConfiguration(apiConf);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getLanguages() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.LANGUAGES, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                ResponseList languages = AsyncTwitterImpl.this.twitter.getLanguages();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotLanguages((ResponseList<HelpResources.Language>)languages);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getPrivacyPolicy() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.PRIVACY_POLICY, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String privacyPolicy = AsyncTwitterImpl.this.twitter.getPrivacyPolicy();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotPrivacyPolicy(privacyPolicy);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getTermsOfService() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.TERMS_OF_SERVICE, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                String tos = AsyncTwitterImpl.this.twitter.getTermsOfService();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotTermsOfService(tos);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getRateLimitStatus() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Map rateLimitStatus = AsyncTwitterImpl.this.twitter.getRateLimitStatus();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRateLimitStatus(rateLimitStatus);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getRateLimitStatus(final String ... resources) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.RATE_LIMIT_STATUS, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                Map rateLimitStatus = AsyncTwitterImpl.this.twitter.getRateLimitStatus(resources);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotRateLimitStatus(rateLimitStatus);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthRequestTokenAsync() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_REQUEST_TOKEN, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RequestToken token = AsyncTwitterImpl.this.twitter.getOAuthRequestToken();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthRequestToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthRequestTokenAsync(final String callbackURL) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_REQUEST_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RequestToken token = AsyncTwitterImpl.this.twitter.getOAuthRequestToken(callbackURL);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthRequestToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthRequestTokenAsync(final String callbackURL, final String xAuthAccessType) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_REQUEST_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RequestToken token = AsyncTwitterImpl.this.twitter.getOAuthRequestToken(callbackURL, xAuthAccessType);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthRequestToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthRequestTokenAsync(final String callbackURL, final String xAuthAccessType, final String xAuthMode) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_REQUEST_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                RequestToken token = AsyncTwitterImpl.this.twitter.getOAuthRequestToken(callbackURL, xAuthAccessType, xAuthMode);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthRequestToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthAccessTokenAsync() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccessToken token = AsyncTwitterImpl.this.twitter.getOAuthAccessToken();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthAccessToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthAccessTokenAsync(final String oauthVerifier) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccessToken token = AsyncTwitterImpl.this.twitter.getOAuthAccessToken(oauthVerifier);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthAccessToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthAccessTokenAsync(final RequestToken requestToken) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccessToken token = AsyncTwitterImpl.this.twitter.getOAuthAccessToken(requestToken);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthAccessToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthAccessTokenAsync(final RequestToken requestToken, final String oauthVerifier) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccessToken token = AsyncTwitterImpl.this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthAccessToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void getOAuthAccessTokenAsync(final String screenName, final String password) {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                AccessToken token = AsyncTwitterImpl.this.twitter.getOAuthAccessToken(screenName, password);
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuthAccessToken(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Class<AsyncTwitterImpl> clazz = AsyncTwitterImpl.class;
        synchronized (AsyncTwitterImpl.class) {
            if (dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dispatcher getDispatcher() {
        if (null != dispatcher) return dispatcher;
        Class<AsyncTwitterImpl> clazz = AsyncTwitterImpl.class;
        synchronized (AsyncTwitterImpl.class) {
            if (null != dispatcher) return dispatcher;
            dispatcher = new DispatcherFactory(this.conf).getInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dispatcher;
        }
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.twitter.setOAuthConsumer(consumerKey, consumerSecret);
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.twitter.getOAuthRequestToken();
    }

    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.twitter.getOAuthRequestToken(callbackUrl);
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        return this.twitter.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken);
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.twitter.getOAuthAccessToken(requestToken, oauthVerifier);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.twitter.setOAuthAccessToken(accessToken);
    }

    public AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        return this.twitter.getOAuthAccessToken(screenName, password);
    }

    public synchronized OAuth2Token getOAuth2Token() throws TwitterException {
        return this.twitter.getOAuth2Token();
    }

    public void setOAuth2Token(OAuth2Token oauth2Token) {
        this.twitter.setOAuth2Token(oauth2Token);
    }

    @Override
    public void getOAuth2TokenAsync() {
        this.getDispatcher().invokeLater((Runnable)new AsyncTask(TwitterMethod.OAUTH_ACCESS_TOKEN, (List)this.listeners){

            @Override
            public void invoke(List<TwitterListener> listeners) throws TwitterException {
                OAuth2Token token = AsyncTwitterImpl.this.twitter.getOAuth2Token();
                for (TwitterListener listener : listeners) {
                    try {
                        listener.gotOAuth2Token(token);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public synchronized void invalidateOAuth2Token() throws TwitterException {
        this.twitter.invalidateOAuth2Token();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsyncTwitterImpl that = (AsyncTwitterImpl)o;
        if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) {
            return false;
        }
        return !(this.twitter != null ? !this.twitter.equals(that.twitter) : that.twitter != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.twitter != null ? this.twitter.hashCode() : 0);
        result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AsyncTwitterImpl{twitter=" + this.twitter + ", listeners=" + this.listeners + '}';
    }

    abstract class AsyncTask
    implements Runnable {
        final List<TwitterListener> listeners;
        final TwitterMethod method;

        AsyncTask(TwitterMethod method, List<TwitterListener> listeners) {
            this.method = method;
            this.listeners = listeners;
        }

        abstract void invoke(List<TwitterListener> var1) throws TwitterException;

        @Override
        public void run() {
            block5: {
                try {
                    this.invoke(this.listeners);
                }
                catch (TwitterException te) {
                    if (this.listeners == null) break block5;
                    for (TwitterListener listener : this.listeners) {
                        try {
                            listener.onException(te, this.method);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }
}

