/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Map;
import twitter4j.AccountSettings;
import twitter4j.AccountTotals;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Friendship;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.OEmbed;
import twitter4j.PagableResponseList;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.SimilarPlaces;
import twitter4j.Status;
import twitter4j.Trends;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.api.HelpResources;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.CategoryJSONImpl;
import twitter4j.internal.json.DirectMessageJSONImpl;
import twitter4j.internal.json.FriendshipJSONImpl;
import twitter4j.internal.json.LanguageJSONImpl;
import twitter4j.internal.json.LazyAccountSettings;
import twitter4j.internal.json.LazyAccountTotals;
import twitter4j.internal.json.LazyDirectMessage;
import twitter4j.internal.json.LazyIDs;
import twitter4j.internal.json.LazyOEmbed;
import twitter4j.internal.json.LazyPagableResponseList;
import twitter4j.internal.json.LazyPlace;
import twitter4j.internal.json.LazyQueryResult;
import twitter4j.internal.json.LazyRelationship;
import twitter4j.internal.json.LazyResponseList;
import twitter4j.internal.json.LazySavedSearch;
import twitter4j.internal.json.LazySimilarPlaces;
import twitter4j.internal.json.LazyStatus;
import twitter4j.internal.json.LazyTrends;
import twitter4j.internal.json.LazyTwitterAPIConfiguration;
import twitter4j.internal.json.LazyUser;
import twitter4j.internal.json.LazyUserList;
import twitter4j.internal.json.LocationJSONImpl;
import twitter4j.internal.json.PlaceJSONImpl;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.SavedSearchJSONImpl;
import twitter4j.internal.json.StatusJSONImpl;
import twitter4j.internal.json.TrendsJSONImpl;
import twitter4j.internal.json.UserJSONImpl;
import twitter4j.internal.json.UserListJSONImpl;
import twitter4j.internal.json.z_T4JInternalFactory;
import twitter4j.internal.json.z_T4JInternalJSONImplFactory;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class z_T4JInternalLazyFactory
implements z_T4JInternalFactory {
    private static final long serialVersionUID = 8032710811910749119L;
    private final z_T4JInternalFactory factory;
    private final Configuration conf;

    public z_T4JInternalLazyFactory(Configuration conf) {
        this.factory = new z_T4JInternalJSONImplFactory(conf);
        this.conf = conf;
    }

    public Status createStatus(JSONObject json) throws TwitterException {
        return new StatusJSONImpl(json);
    }

    public User createUser(JSONObject json) throws TwitterException {
        return new UserJSONImpl(json);
    }

    public UserList createAUserList(JSONObject json) throws TwitterException {
        return new UserListJSONImpl(json);
    }

    public DirectMessage createDirectMessage(JSONObject json) throws TwitterException {
        return new DirectMessageJSONImpl(json);
    }

    public Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse res) throws TwitterException {
        return this.factory.createRateLimitStatuses(res);
    }

    public Status createStatus(HttpResponse res) throws TwitterException {
        return new LazyStatus(res, this.factory);
    }

    public ResponseList<Status> createStatusList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Status>(){

            @Override
            protected ResponseList<Status> createActualResponseList() throws TwitterException {
                return StatusJSONImpl.createStatusList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public Trends createTrends(HttpResponse res) throws TwitterException {
        return new LazyTrends(res, this.factory);
    }

    public ResponseList<Trends> createTrendsList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Trends>(){

            @Override
            protected ResponseList<Trends> createActualResponseList() throws TwitterException {
                return TrendsJSONImpl.createTrendsList((HttpResponse)res, (boolean)z_T4JInternalLazyFactory.this.conf.isJSONStoreEnabled());
            }
        };
    }

    public User createUser(HttpResponse res) throws TwitterException {
        return new LazyUser(res, this.factory);
    }

    public ResponseList<User> createUserList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<User>(){

            @Override
            protected ResponseList<User> createActualResponseList() throws TwitterException {
                return UserJSONImpl.createUserList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public ResponseList<User> createUserListFromJSONArray(final HttpResponse res) throws TwitterException {
        return new LazyPagableResponseList<User>(){

            @Override
            protected ResponseList<User> createActualResponseList() throws TwitterException {
                return UserJSONImpl.createUserList((JSONArray)res.asJSONArray(), (HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public ResponseList<User> createUserListFromJSONArray_Users(final HttpResponse res) throws TwitterException {
        return new LazyPagableResponseList<User>(){

            @Override
            protected ResponseList<User> createActualResponseList() throws TwitterException {
                try {
                    return UserJSONImpl.createUserList((JSONArray)res.asJSONObject().getJSONArray("users"), (HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
                }
                catch (JSONException jsone) {
                    throw new TwitterException((Exception)((Object)jsone));
                }
            }
        };
    }

    public QueryResult createQueryResult(HttpResponse res, Query query) throws TwitterException {
        return new LazyQueryResult(res, this.factory, query);
    }

    public IDs createIDs(HttpResponse res) throws TwitterException {
        return new LazyIDs(res, this.factory);
    }

    public PagableResponseList<User> createPagableUserList(final HttpResponse res) throws TwitterException {
        return new LazyPagableResponseList<User>(){

            @Override
            protected ResponseList<User> createActualResponseList() throws TwitterException {
                return UserJSONImpl.createUserList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public UserList createAUserList(HttpResponse res) throws TwitterException {
        return new LazyUserList(res, this.factory);
    }

    public PagableResponseList<UserList> createPagableUserListList(final HttpResponse res) throws TwitterException {
        return new LazyPagableResponseList<UserList>(){

            @Override
            protected PagableResponseList<UserList> createActualResponseList() throws TwitterException {
                return UserListJSONImpl.createPagableUserListList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public ResponseList<UserList> createUserListList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<UserList>(){

            @Override
            protected ResponseList<UserList> createActualResponseList() throws TwitterException {
                return UserListJSONImpl.createUserListList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public ResponseList<Category> createCategoryList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Category>(){

            @Override
            protected ResponseList<Category> createActualResponseList() throws TwitterException {
                return CategoryJSONImpl.createCategoriesList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public DirectMessage createDirectMessage(HttpResponse res) throws TwitterException {
        return new LazyDirectMessage(res, this.factory);
    }

    public ResponseList<DirectMessage> createDirectMessageList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<DirectMessage>(){

            @Override
            protected ResponseList<DirectMessage> createActualResponseList() throws TwitterException {
                return DirectMessageJSONImpl.createDirectMessageList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public Relationship createRelationship(HttpResponse res) throws TwitterException {
        return new LazyRelationship(res, this.factory);
    }

    public ResponseList<Friendship> createFriendshipList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Friendship>(){

            @Override
            protected ResponseList<Friendship> createActualResponseList() throws TwitterException {
                return FriendshipJSONImpl.createFriendshipList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public AccountTotals createAccountTotals(HttpResponse res) throws TwitterException {
        return new LazyAccountTotals(res, this.factory);
    }

    public AccountSettings createAccountSettings(HttpResponse res) throws TwitterException {
        return new LazyAccountSettings(res, this.factory);
    }

    public SavedSearch createSavedSearch(HttpResponse res) throws TwitterException {
        return new LazySavedSearch(res, this.factory);
    }

    public ResponseList<SavedSearch> createSavedSearchList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<SavedSearch>(){

            @Override
            protected ResponseList<SavedSearch> createActualResponseList() throws TwitterException {
                return SavedSearchJSONImpl.createSavedSearchList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public ResponseList<Location> createLocationList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Location>(){

            @Override
            protected ResponseList<Location> createActualResponseList() throws TwitterException {
                return LocationJSONImpl.createLocationList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public Place createPlace(HttpResponse res) throws TwitterException {
        return new LazyPlace(res, this.factory);
    }

    public ResponseList<Place> createPlaceList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<Place>(){

            @Override
            protected ResponseList<Place> createActualResponseList() throws TwitterException {
                return PlaceJSONImpl.createPlaceList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public <T> ResponseList<T> createEmptyResponseList() {
        return new ResponseListImpl(0, null);
    }

    public OEmbed createOEmbed(HttpResponse res) throws TwitterException {
        return new LazyOEmbed(res, this.factory);
    }

    public SimilarPlaces createSimilarPlaces(HttpResponse res) throws TwitterException {
        return new LazySimilarPlaces(res, this.factory);
    }

    public TwitterAPIConfiguration createTwitterAPIConfiguration(HttpResponse res) throws TwitterException {
        return new LazyTwitterAPIConfiguration(res, this.factory);
    }

    public ResponseList<HelpResources.Language> createLanguageList(final HttpResponse res) throws TwitterException {
        return new LazyResponseList<HelpResources.Language>(){

            @Override
            protected ResponseList<HelpResources.Language> createActualResponseList() throws TwitterException {
                return LanguageJSONImpl.createLanguageList((HttpResponse)res, (Configuration)z_T4JInternalLazyFactory.this.conf);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof z_T4JInternalLazyFactory)) {
            return false;
        }
        z_T4JInternalLazyFactory that = (z_T4JInternalLazyFactory)o;
        return !(this.factory != null ? !this.factory.equals(that.factory) : that.factory != null);
    }

    public int hashCode() {
        return this.factory != null ? this.factory.hashCode() : 0;
    }

    public String toString() {
        return "LazyFactory{factory=" + this.factory + '}';
    }
}

