/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.net.URI;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyUserList
implements UserList {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private UserList target = null;

    LazyUserList(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private UserList getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createAUserList(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public int getId() {
        return this.getTarget().getId();
    }

    public String getName() {
        return this.getTarget().getName();
    }

    public String getFullName() {
        return this.getTarget().getFullName();
    }

    public String getSlug() {
        return this.getTarget().getSlug();
    }

    public String getDescription() {
        return this.getTarget().getDescription();
    }

    public int getSubscriberCount() {
        return this.getTarget().getSubscriberCount();
    }

    public int getMemberCount() {
        return this.getTarget().getMemberCount();
    }

    public URI getURI() {
        return this.getTarget().getURI();
    }

    public boolean isPublic() {
        return this.getTarget().isPublic();
    }

    public User getUser() {
        return this.getTarget().getUser();
    }

    public boolean isFollowing() {
        return this.getTarget().isFollowing();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public int compareTo(UserList target) {
        return this.getTarget().compareTo((Object)target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserList)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyUserList{target=" + this.getTarget() + "}";
    }
}

