/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Map;
import twitter4j.MediaEntity;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyTwitterAPIConfiguration
implements TwitterAPIConfiguration {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private TwitterAPIConfiguration target = null;

    LazyTwitterAPIConfiguration(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private TwitterAPIConfiguration getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createTwitterAPIConfiguration(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public int getPhotoSizeLimit() {
        return this.getTarget().getPhotoSizeLimit();
    }

    public int getShortURLLength() {
        return this.getTarget().getShortURLLength();
    }

    public int getShortURLLengthHttps() {
        return this.getTarget().getShortURLLengthHttps();
    }

    public int getCharactersReservedPerMedia() {
        return this.getTarget().getCharactersReservedPerMedia();
    }

    public Map<Integer, MediaEntity.Size> getPhotoSizes() {
        return this.getTarget().getPhotoSizes();
    }

    public String[] getNonUsernamePaths() {
        return this.getTarget().getNonUsernamePaths();
    }

    public int getMaxMediaPerUpload() {
        return this.getTarget().getMaxMediaPerUpload();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterAPIConfiguration)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyTwitterAPIConfiguration{target=" + this.getTarget() + "}";
    }
}

