/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Date;
import twitter4j.Location;
import twitter4j.RateLimitStatus;
import twitter4j.Trend;
import twitter4j.Trends;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyTrends
implements Trends {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private Trends target = null;

    LazyTrends(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private Trends getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createTrends(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public Trend[] getTrends() {
        return this.getTarget().getTrends();
    }

    public Location getLocation() {
        return this.getTarget().getLocation();
    }

    public Date getAsOf() {
        return this.getTarget().getAsOf();
    }

    public Date getTrendAt() {
        return this.getTarget().getTrendAt();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public int compareTo(Trends target) {
        return this.getTarget().compareTo((Object)target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trends)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyTrends{target=" + this.getTarget() + "}";
    }
}

