/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Date;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.Place;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.SymbolEntity;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyStatus
implements Status {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private Status target = null;

    LazyStatus(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private Status getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createStatus(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public Date getCreatedAt() {
        return this.getTarget().getCreatedAt();
    }

    public long getId() {
        return this.getTarget().getId();
    }

    public String getText() {
        return this.getTarget().getText();
    }

    public String getSource() {
        return this.getTarget().getSource();
    }

    public boolean isTruncated() {
        return this.getTarget().isTruncated();
    }

    public long getInReplyToStatusId() {
        return this.getTarget().getInReplyToStatusId();
    }

    public long getInReplyToUserId() {
        return this.getTarget().getInReplyToUserId();
    }

    public String getInReplyToScreenName() {
        return this.getTarget().getInReplyToScreenName();
    }

    public GeoLocation getGeoLocation() {
        return this.getTarget().getGeoLocation();
    }

    public Place getPlace() {
        return this.getTarget().getPlace();
    }

    public boolean isFavorited() {
        return this.getTarget().isFavorited();
    }

    public int getFavoriteCount() {
        return this.getTarget().getFavoriteCount();
    }

    public boolean isRetweeted() {
        return this.getTarget().isRetweeted();
    }

    public User getUser() {
        return this.getTarget().getUser();
    }

    public boolean isRetweet() {
        return this.getTarget().isRetweet();
    }

    public Status getRetweetedStatus() {
        return this.getTarget().getRetweetedStatus();
    }

    public long[] getContributors() {
        return this.getTarget().getContributors();
    }

    public int getRetweetCount() {
        return this.getTarget().getRetweetCount();
    }

    public boolean isRetweetedByMe() {
        return this.getTarget().isRetweetedByMe();
    }

    public long getCurrentUserRetweetId() {
        return this.getTarget().getCurrentUserRetweetId();
    }

    public boolean isPossiblySensitive() {
        return this.getTarget().isPossiblySensitive();
    }

    public String getIsoLanguageCode() {
        return this.getTarget().getIsoLanguageCode();
    }

    public UserMentionEntity[] getUserMentionEntities() {
        return this.getTarget().getUserMentionEntities();
    }

    public URLEntity[] getURLEntities() {
        return this.getTarget().getURLEntities();
    }

    public HashtagEntity[] getHashtagEntities() {
        return this.getTarget().getHashtagEntities();
    }

    public MediaEntity[] getMediaEntities() {
        return this.getTarget().getMediaEntities();
    }

    public SymbolEntity[] getSymbolEntities() {
        return this.getTarget().getSymbolEntities();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public int compareTo(Status target) {
        return this.getTarget().compareTo((Object)target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyStatus{target=" + this.getTarget() + "}";
    }
}

