/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.RateLimitStatus;
import twitter4j.Relationship;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyRelationship
implements Relationship {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private Relationship target = null;

    LazyRelationship(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private Relationship getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createRelationship(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public long getSourceUserId() {
        return this.getTarget().getSourceUserId();
    }

    public long getTargetUserId() {
        return this.getTarget().getTargetUserId();
    }

    public boolean isSourceBlockingTarget() {
        return this.getTarget().isSourceBlockingTarget();
    }

    public String getSourceUserScreenName() {
        return this.getTarget().getSourceUserScreenName();
    }

    public String getTargetUserScreenName() {
        return this.getTarget().getTargetUserScreenName();
    }

    public boolean isSourceFollowingTarget() {
        return this.getTarget().isSourceFollowingTarget();
    }

    public boolean isTargetFollowingSource() {
        return this.getTarget().isTargetFollowingSource();
    }

    public boolean isSourceFollowedByTarget() {
        return this.getTarget().isSourceFollowedByTarget();
    }

    public boolean isTargetFollowedBySource() {
        return this.getTarget().isTargetFollowedBySource();
    }

    public boolean isSourceNotificationsEnabled() {
        return this.getTarget().isSourceNotificationsEnabled();
    }

    public boolean isSourceWantRetweets() {
        return this.getTarget().isSourceWantRetweets();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyRelationship{target=" + this.getTarget() + "}";
    }
}

