/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.List;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyQueryResult
implements QueryResult {
    private static final long serialVersionUID = 1469029015622811726L;
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private QueryResult target = null;
    private Query query;

    LazyQueryResult(HttpResponse res, z_T4JInternalFactory factory, Query query) {
        this.res = res;
        this.factory = factory;
        this.query = query;
    }

    private QueryResult getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createQueryResult(this.res, this.query);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public long getSinceId() {
        return this.getTarget().getSinceId();
    }

    public long getMaxId() {
        return this.getTarget().getMaxId();
    }

    public String getRefreshUrl() {
        return this.getRefreshURL();
    }

    public String getRefreshURL() {
        return this.getTarget().getRefreshURL();
    }

    public int getCount() {
        return this.getTarget().getCount();
    }

    public double getCompletedIn() {
        return this.getTarget().getCompletedIn();
    }

    public String getQuery() {
        return this.getTarget().getQuery();
    }

    public List<Status> getTweets() {
        return this.getTarget().getTweets();
    }

    public Query nextQuery() {
        return this.getTarget().nextQuery();
    }

    public boolean hasNext() {
        return this.getTarget().hasNext();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryResult)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyQueryResult{target=" + this.getTarget() + "}";
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }
}

