/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.GeoLocation;
import twitter4j.Place;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyPlace
implements Place {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private Place target = null;

    LazyPlace(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private Place getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createPlace(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public String getName() {
        return this.getTarget().getName();
    }

    public String getStreetAddress() {
        return this.getTarget().getStreetAddress();
    }

    public String getCountryCode() {
        return this.getTarget().getCountryCode();
    }

    public String getId() {
        return this.getTarget().getId();
    }

    public String getCountry() {
        return this.getTarget().getCountry();
    }

    public String getPlaceType() {
        return this.getTarget().getPlaceType();
    }

    public String getURL() {
        return this.getTarget().getURL();
    }

    public String getFullName() {
        return this.getTarget().getFullName();
    }

    public String getBoundingBoxType() {
        return this.getTarget().getBoundingBoxType();
    }

    public GeoLocation[][] getBoundingBoxCoordinates() {
        return this.getTarget().getBoundingBoxCoordinates();
    }

    public String getGeometryType() {
        return this.getTarget().getGeometryType();
    }

    public GeoLocation[][] getGeometryCoordinates() {
        return this.getTarget().getGeometryCoordinates();
    }

    public Place[] getContainedWithIn() {
        return this.getTarget().getContainedWithIn();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public int compareTo(Place target) {
        return this.getTarget().compareTo((Object)target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Place)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyPlace{target=" + this.getTarget() + "}";
    }
}

