/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.OEmbed;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyOEmbed
implements OEmbed {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private OEmbed target = null;

    LazyOEmbed(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private OEmbed getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createOEmbed(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public String getHtml() {
        return this.getTarget().getHtml();
    }

    public String getAuthorName() {
        return this.getTarget().getAuthorName();
    }

    public String getURL() {
        return this.getTarget().getURL();
    }

    public String getVersion() {
        return this.getTarget().getVersion();
    }

    public long getCacheAge() {
        return this.getTarget().getCacheAge();
    }

    public String getAuthorURL() {
        return this.getTarget().getAuthorURL();
    }

    public int getWidth() {
        return this.getTarget().getWidth();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OEmbed)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyOEmbed{target=" + this.getTarget() + "}";
    }
}

