/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.IDs;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyIDs
implements IDs {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private IDs target = null;

    LazyIDs(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private IDs getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createIDs(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public long[] getIDs() {
        return this.getTarget().getIDs();
    }

    public boolean hasPrevious() {
        return this.getTarget().hasPrevious();
    }

    public long getPreviousCursor() {
        return this.getTarget().getPreviousCursor();
    }

    public boolean hasNext() {
        return this.getTarget().hasNext();
    }

    public long getNextCursor() {
        return this.getTarget().getNextCursor();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyIDs{target=" + this.getTarget() + "}";
    }
}

